/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.entities.bosses.manager.phase;

import com.sofodev.armorplus.registry.entities.bosses.DemonicDragonEntity;
import com.sofodev.armorplus.registry.entities.bosses.manager.PhaseType;
import com.sofodev.armorplus.registry.entities.bosses.manager.phase.Phase;
import javax.annotation.Nullable;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.EndPodiumFeature;

public class HoldingPatternPhase
extends Phase {
    private static final EntityPredicate NEW_TARGET_TARGETING = new EntityPredicate().func_221013_a(64.0);
    private Path currentPath;
    private Vector3d targetLocation;
    private boolean clockwise;

    public HoldingPatternPhase(DemonicDragonEntity dragonIn) {
        super(dragonIn);
    }

    public PhaseType<HoldingPatternPhase> getPhase() {
        return PhaseType.HOLDING_PATTERN;
    }

    @Override
    public void serverTick() {
        double d0;
        double d = d0 = this.targetLocation == null ? 0.0 : this.targetLocation.func_186679_c(this.dragon.func_226277_ct_(), this.dragon.func_226278_cu_(), this.dragon.func_226281_cx_());
        if (d0 < 100.0 || d0 > 22500.0 || this.dragon.field_70123_F || this.dragon.field_70124_G) {
            this.findNewTarget();
        }
    }

    @Override
    public void initPhase() {
        this.currentPath = null;
        this.targetLocation = null;
    }

    @Override
    @Nullable
    public Vector3d getTargetLocation() {
        return this.targetLocation;
    }

    private void findNewTarget() {
        if (this.currentPath != null && this.currentPath.func_75879_b()) {
            int i;
            BlockPos blockpos = this.dragon.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos((Vector3i)EndPodiumFeature.field_186139_a));
            int n = i = this.dragon.getDragonFight() == null ? 0 : this.dragon.getDragonFight().getNumAliveCrystals();
            if (this.dragon.func_70681_au().nextInt(i + 3) == 0) {
                this.dragon.getPhaseManager().setPhase(PhaseType.LANDING_APPROACH);
                return;
            }
            double d0 = 64.0;
            PlayerEntity playerentity = this.dragon.field_70170_p.func_217359_a(NEW_TARGET_TARGETING, (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
            if (playerentity != null) {
                d0 = blockpos.func_218138_a((IPosition)playerentity.func_213303_ch(), true) / 512.0;
            }
            if (!(playerentity == null || playerentity.field_71075_bZ.field_75102_a || this.dragon.func_70681_au().nextInt(MathHelper.func_76130_a((int)((int)d0)) + 2) != 0 && this.dragon.func_70681_au().nextInt(i + 2) != 0)) {
                this.strafePlayer(playerentity);
                return;
            }
        }
        if (this.currentPath == null || this.currentPath.func_75879_b()) {
            int j;
            int k = j = this.dragon.findClosestNode();
            if (this.dragon.func_70681_au().nextInt(8) == 0) {
                this.clockwise = !this.clockwise;
                k = j + 6;
            }
            k = this.clockwise ? ++k : --k;
            if (this.dragon.getDragonFight() != null && this.dragon.getDragonFight().getNumAliveCrystals() >= 0) {
                if ((k %= 12) < 0) {
                    k += 12;
                }
            } else {
                k -= 12;
                k &= 7;
                k += 12;
            }
            this.currentPath = this.dragon.findPath(j, k, null);
            if (this.currentPath != null) {
                this.currentPath.func_75875_a();
            }
        }
        this.navigateToNextPathNode();
    }

    private void strafePlayer(PlayerEntity player) {
        this.dragon.getPhaseManager().setPhase(PhaseType.STRAFE_PLAYER);
        this.dragon.getPhaseManager().getPhase(PhaseType.STRAFE_PLAYER).setTarget((LivingEntity)player);
    }

    private void navigateToNextPathNode() {
        if (this.currentPath != null && !this.currentPath.func_75879_b()) {
            double d2;
            BlockPos vector3i = this.currentPath.func_242948_g();
            this.currentPath.func_75875_a();
            double d0 = vector3i.func_177958_n();
            double d1 = vector3i.func_177952_p();
            while ((d2 = (double)((float)vector3i.func_177956_o() + this.dragon.func_70681_au().nextFloat() * 20.0f)) < (double)vector3i.func_177956_o()) {
            }
            this.targetLocation = new Vector3d(d0, d2, d1);
        }
    }
}

