/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.entities.bosses.manager.phase;

import com.sofodev.armorplus.registry.entities.bosses.DemonicDragonEntity;
import com.sofodev.armorplus.registry.entities.bosses.manager.PhaseType;
import com.sofodev.armorplus.registry.entities.bosses.manager.phase.Phase;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.EndPodiumFeature;

public class LandingApproachPhase
extends Phase {
    private static final EntityPredicate NEAR_EGG_TARGETING = new EntityPredicate().func_221013_a(128.0);
    private Path currentPath;
    private Vector3d targetLocation;

    public LandingApproachPhase(DemonicDragonEntity dragonIn) {
        super(dragonIn);
    }

    public PhaseType<LandingApproachPhase> getPhase() {
        return PhaseType.LANDING_APPROACH;
    }

    @Override
    public void initPhase() {
        this.currentPath = null;
        this.targetLocation = null;
    }

    @Override
    public void serverTick() {
        double d0;
        double d = d0 = this.targetLocation == null ? 0.0 : this.targetLocation.func_186679_c(this.dragon.func_226277_ct_(), this.dragon.func_226278_cu_(), this.dragon.func_226281_cx_());
        if (d0 < 100.0 || d0 > 22500.0 || this.dragon.field_70123_F || this.dragon.field_70124_G) {
            this.findNewTarget();
        }
    }

    @Override
    @Nullable
    public Vector3d getTargetLocation() {
        return this.targetLocation;
    }

    private void findNewTarget() {
        if (this.currentPath == null || this.currentPath.func_75879_b()) {
            int j;
            int i = this.dragon.findClosestNode();
            BlockPos blockpos = this.dragon.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.field_186139_a);
            PlayerEntity playerentity = this.dragon.field_70170_p.func_217359_a(NEAR_EGG_TARGETING, (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
            if (playerentity != null) {
                Vector3d vector3d = new Vector3d(playerentity.func_226277_ct_(), 0.0, playerentity.func_226281_cx_()).func_72432_b();
                j = this.dragon.findClosestNode(-vector3d.field_72450_a * 40.0, 105.0, -vector3d.field_72449_c * 40.0);
            } else {
                j = this.dragon.findClosestNode(40.0, blockpos.func_177956_o(), 0.0);
            }
            PathPoint pathpoint = new PathPoint(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
            this.currentPath = this.dragon.findPath(i, j, pathpoint);
            if (this.currentPath != null) {
                this.currentPath.func_75875_a();
            }
        }
        this.navigateToNextPathNode();
        if (this.currentPath != null && this.currentPath.func_75879_b()) {
            this.dragon.getPhaseManager().setPhase(PhaseType.LANDING);
        }
    }

    private void navigateToNextPathNode() {
        if (this.currentPath != null && !this.currentPath.func_75879_b()) {
            double d2;
            BlockPos vector3i = this.currentPath.func_242948_g();
            this.currentPath.func_75875_a();
            double d0 = vector3i.func_177958_n();
            double d1 = vector3i.func_177952_p();
            while ((d2 = (double)((float)vector3i.func_177956_o() + this.dragon.func_70681_au().nextFloat() * 20.0f)) < (double)vector3i.func_177956_o()) {
            }
            this.targetLocation = new Vector3d(d0, d2, d1);
        }
    }
}

