/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.entities.bosses.manager.phase;

import com.sofodev.armorplus.registry.entities.bosses.DemonicDragonEntity;
import com.sofodev.armorplus.registry.entities.bosses.manager.PhaseType;
import com.sofodev.armorplus.registry.entities.bosses.manager.phase.Phase;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.DragonFireballEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StrafePlayerPhase
extends Phase {
    private static final Logger LOGGER = LogManager.getLogger();
    private int fireballCharge;
    private Path currentPath;
    private Vector3d targetLocation;
    private LivingEntity attackTarget;
    private boolean holdingPatternClockwise;

    public StrafePlayerPhase(DemonicDragonEntity dragonIn) {
        super(dragonIn);
    }

    @Override
    public void serverTick() {
        if (this.attackTarget == null) {
            LOGGER.warn("Skipping player strafe phase because no player was found");
            this.dragon.getPhaseManager().setPhase(PhaseType.HOLDING_PATTERN);
        } else {
            double d12;
            if (this.currentPath != null && this.currentPath.func_75879_b()) {
                double d0 = this.attackTarget.func_226277_ct_();
                double d1 = this.attackTarget.func_226281_cx_();
                double d2 = d0 - this.dragon.func_226277_ct_();
                double d3 = d1 - this.dragon.func_226281_cx_();
                double d4 = MathHelper.func_76133_a((double)(d2 * d2 + d3 * d3));
                double d5 = Math.min((double)0.4f + d4 / 80.0 - 1.0, 10.0);
                this.targetLocation = new Vector3d(d0, this.attackTarget.func_226278_cu_() + d5, d1);
            }
            double d = d12 = this.targetLocation == null ? 0.0 : this.targetLocation.func_186679_c(this.dragon.func_226277_ct_(), this.dragon.func_226278_cu_(), this.dragon.func_226281_cx_());
            if (d12 < 100.0 || d12 > 22500.0) {
                this.findNewTarget();
            }
            double d13 = 64.0;
            if (this.attackTarget.func_70068_e((Entity)this.dragon) < 4096.0) {
                if (this.dragon.func_70685_l((Entity)this.attackTarget)) {
                    ++this.fireballCharge;
                    Vector3d vector3d1 = new Vector3d(this.attackTarget.func_226277_ct_() - this.dragon.func_226277_ct_(), 0.0, this.attackTarget.func_226281_cx_() - this.dragon.func_226281_cx_()).func_72432_b();
                    Vector3d vector3d = new Vector3d((double)MathHelper.func_76126_a((float)(this.dragon.rotationYaw * ((float)Math.PI / 180))), 0.0, (double)(-MathHelper.func_76134_b((float)(this.dragon.rotationYaw * ((float)Math.PI / 180))))).func_72432_b();
                    float f1 = (float)vector3d.func_72430_b(vector3d1);
                    float f = (float)(Math.acos(f1) * 57.2957763671875);
                    f += 0.5f;
                    if (this.fireballCharge >= 5 && f >= 0.0f && f < 10.0f) {
                        double d14 = 1.0;
                        Vector3d vector3d2 = this.dragon.func_70676_i(1.0f);
                        double d6 = this.dragon.func_226277_ct_() - vector3d2.field_72450_a;
                        double d7 = this.dragon.func_226283_e_(0.5) + 0.5;
                        double d8 = this.dragon.func_226281_cx_() - vector3d2.field_72449_c;
                        double d9 = this.attackTarget.func_226277_ct_() - d6;
                        double d10 = this.attackTarget.func_226283_e_(0.5) - d7;
                        double d11 = this.attackTarget.func_226281_cx_() - d8;
                        if (!this.dragon.func_174814_R()) {
                            this.dragon.field_70170_p.func_217378_a((PlayerEntity)null, 1017, this.dragon.func_233580_cy_(), 0);
                        }
                        DragonFireballEntity dragonfireballentity = new DragonFireballEntity(this.dragon.field_70170_p, (LivingEntity)this.dragon, d9, d10, d11);
                        dragonfireballentity.func_70012_b(d6, d7, d8, 0.0f, 0.0f);
                        this.dragon.field_70170_p.func_217376_c((Entity)dragonfireballentity);
                        this.fireballCharge = 0;
                        if (this.currentPath != null) {
                            while (!this.currentPath.func_75879_b()) {
                                this.currentPath.func_75875_a();
                            }
                        }
                        this.dragon.getPhaseManager().setPhase(PhaseType.HOLDING_PATTERN);
                    }
                } else if (this.fireballCharge > 0) {
                    --this.fireballCharge;
                }
            } else if (this.fireballCharge > 0) {
                --this.fireballCharge;
            }
        }
    }

    private void findNewTarget() {
        if (this.currentPath == null || this.currentPath.func_75879_b()) {
            int i;
            int j = i = this.dragon.findClosestNode();
            if (this.dragon.func_70681_au().nextInt(8) == 0) {
                this.holdingPatternClockwise = !this.holdingPatternClockwise;
                j = i + 6;
            }
            j = this.holdingPatternClockwise ? ++j : --j;
            if (this.dragon.getDragonFight() != null && this.dragon.getDragonFight().getNumAliveCrystals() > 0) {
                if ((j %= 12) < 0) {
                    j += 12;
                }
            } else {
                j -= 12;
                j &= 7;
                j += 12;
            }
            this.currentPath = this.dragon.findPath(i, j, null);
            if (this.currentPath != null) {
                this.currentPath.func_75875_a();
            }
        }
        this.navigateToNextPathNode();
    }

    private void navigateToNextPathNode() {
        if (this.currentPath != null && !this.currentPath.func_75879_b()) {
            double d1;
            BlockPos vector3i = this.currentPath.func_242948_g();
            this.currentPath.func_75875_a();
            double d0 = vector3i.func_177958_n();
            double d2 = vector3i.func_177952_p();
            while ((d1 = (double)((float)vector3i.func_177956_o() + this.dragon.func_70681_au().nextFloat() * 20.0f)) < (double)vector3i.func_177956_o()) {
            }
            this.targetLocation = new Vector3d(d0, d1, d2);
        }
    }

    @Override
    public void initPhase() {
        this.fireballCharge = 0;
        this.targetLocation = null;
        this.currentPath = null;
        this.attackTarget = null;
    }

    public void setTarget(LivingEntity p_188686_1_) {
        this.attackTarget = p_188686_1_;
        int i = this.dragon.findClosestNode();
        int j = this.dragon.findClosestNode(this.attackTarget.func_226277_ct_(), this.attackTarget.func_226278_cu_(), this.attackTarget.func_226281_cx_());
        int k = MathHelper.func_76128_c((double)this.attackTarget.func_226277_ct_());
        int l = MathHelper.func_76128_c((double)this.attackTarget.func_226281_cx_());
        double d0 = (double)k - this.dragon.func_226277_ct_();
        double d1 = (double)l - this.dragon.func_226281_cx_();
        double d2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        double d3 = Math.min((double)0.4f + d2 / 80.0 - 1.0, 10.0);
        int i1 = MathHelper.func_76128_c((double)(this.attackTarget.func_226278_cu_() + d3));
        PathPoint pathpoint = new PathPoint(k, i1, l);
        this.currentPath = this.dragon.findPath(i, j, pathpoint);
        if (this.currentPath != null) {
            this.currentPath.func_75875_a();
            this.navigateToNextPathNode();
        }
    }

    @Override
    @Nullable
    public Vector3d getTargetLocation() {
        return this.targetLocation;
    }

    public PhaseType<StrafePlayerPhase> getPhase() {
        return PhaseType.STRAFE_PLAYER;
    }
}

