/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.entities.bosses.manager.phase;

import com.sofodev.armorplus.registry.entities.bosses.DemonicDragonEntity;
import com.sofodev.armorplus.registry.entities.bosses.manager.PhaseType;
import com.sofodev.armorplus.registry.entities.bosses.manager.phase.Phase;
import javax.annotation.Nullable;
import net.minecraft.dispenser.IPosition;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.EndPodiumFeature;

public class TakeoffPhase
extends Phase {
    private boolean firstTick;
    private Path currentPath;
    private Vector3d targetLocation;

    public TakeoffPhase(DemonicDragonEntity dragonIn) {
        super(dragonIn);
    }

    @Override
    public void serverTick() {
        if (!this.firstTick && this.currentPath != null) {
            BlockPos blockpos = this.dragon.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.field_186139_a);
            if (!blockpos.func_218137_a((IPosition)this.dragon.func_213303_ch(), 10.0)) {
                this.dragon.getPhaseManager().setPhase(PhaseType.HOLDING_PATTERN);
            }
        } else {
            this.firstTick = false;
            this.findNewTarget();
        }
    }

    @Override
    public void initPhase() {
        this.firstTick = true;
        this.currentPath = null;
        this.targetLocation = null;
    }

    private void findNewTarget() {
        int i = this.dragon.findClosestNode();
        Vector3d vector3d = this.dragon.func_213286_i(1.0f);
        int j = this.dragon.findClosestNode(-vector3d.field_72450_a * 40.0, 105.0, -vector3d.field_72449_c * 40.0);
        if (this.dragon.getDragonFight() != null && this.dragon.getDragonFight().getNumAliveCrystals() > 0) {
            if ((j %= 12) < 0) {
                j += 12;
            }
        } else {
            j -= 12;
            j &= 7;
            j += 12;
        }
        this.currentPath = this.dragon.findPath(i, j, null);
        this.navigateToNextPathNode();
    }

    private void navigateToNextPathNode() {
        if (this.currentPath != null) {
            this.currentPath.func_75875_a();
            if (!this.currentPath.func_75879_b()) {
                double d0;
                BlockPos vector3i = this.currentPath.func_242948_g();
                this.currentPath.func_75875_a();
                while ((d0 = (double)((float)vector3i.func_177956_o() + this.dragon.func_70681_au().nextFloat() * 20.0f)) < (double)vector3i.func_177956_o()) {
                }
                this.targetLocation = new Vector3d((double)vector3i.func_177958_n(), d0, (double)vector3i.func_177952_p());
            }
        }
    }

    @Override
    @Nullable
    public Vector3d getTargetLocation() {
        return this.targetLocation;
    }

    public PhaseType<TakeoffPhase> getPhase() {
        return PhaseType.TAKEOFF;
    }
}

