/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.entities.normal;

import com.sofodev.armorplus.registry.ModEntities;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class FrostWolfAlphaEntity
extends AnimalEntity
implements IAnimatable,
IAngerable {
    private static final DataParameter<Boolean> DATA_INTERESTED_ID = EntityDataManager.func_187226_a(FrostWolfAlphaEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> DATA_COLLAR_COLOR = EntityDataManager.func_187226_a(FrostWolfAlphaEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DATA_REMAINING_ANGER_TIME = EntityDataManager.func_187226_a(FrostWolfAlphaEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final RangedInteger PERSISTENT_ANGER_TIME = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private UUID persistentAngerTarget;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public FrostWolfAlphaEntity(EntityType<? extends FrostWolfAlphaEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, arg_0 -> ((FrostWolfAlphaEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(7, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractSkeletonEntity.class, false));
        this.field_70715_bh.func_75776_a(8, (Goal)new ResetAngerGoal((MobEntity)this, true));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233823_f_, 5.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_INTERESTED_ID, (Object)false);
        this.field_70180_af.func_187214_a(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        this.func_233682_c_(tag);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (!this.field_70170_p.field_72995_K) {
            this.func_241358_a_((ServerWorld)this.field_70170_p, tag);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity target) {
        boolean canHurtTarget = target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_233637_b_(Attributes.field_233823_f_)));
        if (canHurtTarget) {
            this.func_174815_a((LivingEntity)this, target);
        }
        return canHurtTarget;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        Item item = stack.func_77973_b();
        if (!this.field_70170_p.field_72995_K) {
            if (item == Items.field_151103_aS && !this.func_233678_J__()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
                return ActionResultType.SUCCESS;
            }
            return super.func_230254_b_(player, hand);
        }
        return super.func_230254_b_(player, hand);
    }

    public boolean func_70877_b(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item.func_219971_r() && item.func_219967_s().func_221467_c();
    }

    public int func_70641_bl() {
        return 8;
    }

    public int func_230256_F__() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_REMAINING_ANGER_TIME);
    }

    public void func_230260_a__(int timer) {
        this.field_70180_af.func_187227_b(DATA_REMAINING_ANGER_TIME, (Object)timer);
    }

    public void func_230258_H__() {
        this.func_230260_a__(PERSISTENT_ANGER_TIME.func_233018_a_(this.field_70146_Z));
    }

    @Nullable
    public UUID func_230257_G__() {
        return this.persistentAngerTarget;
    }

    public void func_230259_a_(@Nullable UUID targetUUID) {
        this.persistentAngerTarget = targetUUID;
    }

    public boolean func_70878_b(AnimalEntity entity) {
        if (entity == this) {
            return false;
        }
        if (!(entity instanceof FrostWolfAlphaEntity)) {
            return false;
        }
        FrostWolfAlphaEntity frostWolfAlphaEntity = (FrostWolfAlphaEntity)entity;
        return this.func_70880_s() && frostWolfAlphaEntity.func_70880_s();
    }

    @Nullable
    public FrostWolfAlphaEntity getBreedOffspring(ServerWorld world, AgeableEntity ageableEntity) {
        return (FrostWolfAlphaEntity)((EntityType)ModEntities.FROST_WOLF_ALPHA.get()).func_200721_a((World)world);
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !this.func_233678_J__() && super.func_184652_a(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, (double)(0.6f * this.func_70047_e()), (double)(this.func_213311_cf() * 0.4f));
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return size.field_220316_b * 0.8f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187857_gE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (!event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

