/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.entities.normal;

import com.sofodev.armorplus.registry.ModEntities;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class FrostWolfEntity
extends TameableEntity
implements IAnimatable,
IAngerable {
    private static final DataParameter<Boolean> DATA_INTERESTED_ID = EntityDataManager.func_187226_a(FrostWolfEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> DATA_COLLAR_COLOR = EntityDataManager.func_187226_a(FrostWolfEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DATA_REMAINING_ANGER_TIME = EntityDataManager.func_187226_a(FrostWolfEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final Predicate<LivingEntity> PREY_SELECTOR = entity -> {
        EntityType type = entity.func_200600_R();
        return type == EntityType.field_200737_ac || type == EntityType.field_200724_aC || type == EntityType.field_200729_aH || type == EntityType.field_200736_ab || type == EntityType.field_220356_B;
    };
    private static final RangedInteger PERSISTENT_ANGER_TIME = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private UUID persistentAngerTarget;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public FrostWolfEntity(EntityType<? extends FrostWolfEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_70903_f(false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, arg_0 -> ((FrostWolfEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(5, (Goal)new NonTamedTargetGoal((TameableEntity)this, AnimalEntity.class, false, PREY_SELECTOR));
        this.field_70715_bh.func_75776_a(6, (Goal)new NonTamedTargetGoal((TameableEntity)this, TurtleEntity.class, false, TurtleEntity.field_203029_bx));
        this.field_70715_bh.func_75776_a(7, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractSkeletonEntity.class, false));
        this.field_70715_bh.func_75776_a(8, (Goal)new ResetAngerGoal((MobEntity)this, true));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233823_f_, 3.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_INTERESTED_ID, (Object)false);
        this.field_70180_af.func_187214_a(DATA_COLLAR_COLOR, (Object)DyeColor.RED.func_196059_a());
        this.field_70180_af.func_187214_a(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74774_a("CollarColor", (byte)this.getCollarColor().func_196059_a());
        this.func_233682_c_(tag);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_150297_b("CollarColor", 99)) {
            this.setCollarColor(DyeColor.func_196056_a((int)tag.func_74762_e("CollarColor")));
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_241358_a_((ServerWorld)this.field_70170_p, tag);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        this.func_233687_w_(false);
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity target) {
        boolean canHurtTarget = target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_233637_b_(Attributes.field_233823_f_)));
        if (canHurtTarget) {
            this.func_174815_a((LivingEntity)this, target);
        }
        return canHurtTarget;
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(30.0);
            this.func_70606_j(30.0f);
        } else {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(10.0);
        }
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(5.0);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        Item item = stack.func_77973_b();
        if (this.field_70170_p.field_72995_K) {
            boolean flag = this.func_152114_e((LivingEntity)player) || this.func_70909_n() || item == Items.field_151103_aS && !this.func_70909_n() && !this.func_233678_J__();
            return flag ? ActionResultType.CONSUME : ActionResultType.PASS;
        }
        if (this.func_70909_n()) {
            if (this.func_70877_b(stack) && this.func_110143_aJ() < this.func_110138_aP()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                this.func_70691_i(item.func_219967_s().func_221466_a());
                return ActionResultType.SUCCESS;
            }
            if (!(item instanceof DyeItem)) {
                ActionResultType actionresulttype = super.func_230254_b_(player, hand);
                if ((!actionresulttype.func_226246_a_() || this.func_70631_g_()) && this.func_152114_e((LivingEntity)player)) {
                    this.func_233687_w_(!this.func_233685_eM_());
                    this.field_70703_bu = false;
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    return ActionResultType.SUCCESS;
                }
                return actionresulttype;
            }
            DyeColor dyecolor = ((DyeItem)item).func_195962_g();
            if (dyecolor != this.getCollarColor()) {
                this.setCollarColor(dyecolor);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
        } else if (item == Items.field_151103_aS && !this.func_233678_J__()) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                this.func_193101_c(player);
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.func_233687_w_(true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    public boolean func_70877_b(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item.func_219971_r() && item.func_219967_s().func_221467_c();
    }

    public int func_70641_bl() {
        return 8;
    }

    public int func_230256_F__() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_REMAINING_ANGER_TIME);
    }

    public void func_230260_a__(int timer) {
        this.field_70180_af.func_187227_b(DATA_REMAINING_ANGER_TIME, (Object)timer);
    }

    public void func_230258_H__() {
        this.func_230260_a__(PERSISTENT_ANGER_TIME.func_233018_a_(this.field_70146_Z));
    }

    @Nullable
    public UUID func_230257_G__() {
        return this.persistentAngerTarget;
    }

    public void func_230259_a_(@Nullable UUID targetUUID) {
        this.persistentAngerTarget = targetUUID;
    }

    public DyeColor getCollarColor() {
        return DyeColor.func_196056_a((int)((Integer)this.field_70180_af.func_187225_a(DATA_COLLAR_COLOR)));
    }

    public void setCollarColor(DyeColor color) {
        this.field_70180_af.func_187227_b(DATA_COLLAR_COLOR, (Object)color.func_196059_a());
    }

    public void setIsInterested(boolean interested) {
        this.field_70180_af.func_187227_b(DATA_INTERESTED_ID, (Object)interested);
    }

    public boolean func_70878_b(AnimalEntity entity) {
        if (entity == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(entity instanceof FrostWolfEntity)) {
            return false;
        }
        FrostWolfEntity wolfentity = (FrostWolfEntity)entity;
        if (!wolfentity.func_70909_n()) {
            return false;
        }
        if (wolfentity.func_233684_eK_()) {
            return false;
        }
        return this.func_70880_s() && wolfentity.func_70880_s();
    }

    @Nullable
    public FrostWolfEntity getBreedOffspring(ServerWorld world, AgeableEntity ageableEntity) {
        FrostWolfEntity wolfEntity = (FrostWolfEntity)((EntityType)ModEntities.FROST_WOLF.get()).func_200721_a((World)world);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            wolfEntity.func_184754_b(uuid);
            wolfEntity.func_70903_f(true);
        }
        return wolfEntity;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !this.func_233678_J__() && super.func_184652_a(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, (double)(0.6f * this.func_70047_e()), (double)(this.func_213311_cf() * 0.4f));
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return size.field_220316_b * 0.8f;
    }

    public int func_70646_bf() {
        return this.func_233684_eK_() ? 20 : super.func_70646_bf();
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187857_gE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walking", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

