/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.items.armors;

import com.sofodev.armorplus.registry.items.armors.IAPArmor;
import com.sofodev.armorplus.registry.items.extras.Buff;
import com.sofodev.armorplus.registry.items.extras.BuffInstance;
import com.sofodev.armorplus.utils.ItemArmorUtility;
import com.sofodev.armorplus.utils.RomanNumeralUtil;
import com.sofodev.armorplus.utils.ToolTipUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class APArmorItem
extends ArmorItem {
    private IAPArmor mat;

    public APArmorItem(IAPArmor mat, EquipmentSlotType slot) {
        super(mat.get(), slot, mat.isImmuneToFire() ? mat.getProperties().func_200915_b(mat.get().func_200896_a(slot)).func_234689_a_() : mat.getProperties().func_200915_b(mat.get().func_200896_a(slot)));
        this.mat = mat;
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (!world.field_72995_K && this.mat.config().enableArmorEffects.get().booleanValue()) {
            if (this.mat.getBuffInstances().get() == null || this.mat.getBuffInstances().get().isEmpty()) {
                return;
            }
            this.mat.getBuffInstances().get().forEach(instance -> {
                if (instance.getBuff() instanceof Buff && instance.isEnabled()) {
                    if (instance.getBuff().requiresFullSet()) {
                        if (ItemArmorUtility.areExactMatch(this.mat, player)) {
                            instance.onArmorTick(stack, world, player);
                        }
                    } else {
                        instance.onArmorTick(stack, world, player);
                    }
                }
            });
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!this.mat.getBuffInstances().get().isEmpty()) {
            tooltip.add((ITextComponent)ToolTipUtils.translate(TextFormatting.YELLOW, "tooltip.armorplus.condition", this.mat.config().enableArmorEffects.get() != false ? "" : "(DISABLED)"));
            tooltip.add((ITextComponent)ToolTipUtils.translate(TextFormatting.GOLD, "tooltip.armorplus.condition.full_set", new Object[0]));
            tooltip.add((ITextComponent)ToolTipUtils.translate(TextFormatting.GREEN, "tooltip.armorplus.provides", new Object[0]));
            for (BuffInstance buff : this.mat.getBuffInstances().get()) {
                int lvl = buff.getAmplifier() + 1;
                String theLvl = lvl > 0 ? " " + RomanNumeralUtil.generate(lvl) : "";
                tooltip.add((ITextComponent)ToolTipUtils.translate(TextFormatting.DARK_AQUA, "tooltip.armorplus.buff", buff.getTranslatedName(), theLvl));
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public IArmorMaterial func_200880_d() {
        return this.mat.get();
    }

    public IAPArmor getMat() {
        return this.mat;
    }
}

