/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.items.armors;

import com.sofodev.armorplus.ArmorPlus;
import com.sofodev.armorplus.config.ArmorPlusConfig;
import com.sofodev.armorplus.registry.items.armors.APArmorProperties;
import com.sofodev.armorplus.registry.items.armors.IAPArmor;
import com.sofodev.armorplus.registry.items.extras.Buff;
import com.sofodev.armorplus.registry.items.extras.BuffInstance;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.TextFormatting;

public enum APArmorMaterial implements IAPArmor
{
    COAL((IArmorMaterial)APArmorProperties.COAL_PROP, TextFormatting.GRAY, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.NIGHT_VISION, 0))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.coalMaterial;
        }
    }
    ,
    REDSTONE((IArmorMaterial)APArmorProperties.REDSTONE_PROP, TextFormatting.DARK_RED, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.HASTE, 1))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.redstoneMaterial;
        }
    }
    ,
    LAPIS((IArmorMaterial)APArmorProperties.LAPIS_PROP, TextFormatting.DARK_BLUE, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.WATER_BREATHING, 0))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.lapisMaterial;
        }
    }
    ,
    CHICKEN((IArmorMaterial)APArmorProperties.CHICKEN_PROP, TextFormatting.WHITE, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.SPEED, 3))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.chickenMaterial;
        }
    }
    ,
    SLIME((IArmorMaterial)APArmorProperties.SLIME_PROP, TextFormatting.GREEN, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.JUMP_BOOST, 3), new BuffInstance(Buff.SLOW_FALLING, 1))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.slimeMaterial;
        }
    }
    ,
    EMERALD((IArmorMaterial)APArmorProperties.EMERALD_PROP, TextFormatting.DARK_GREEN, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.SPEED, 1))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.emeraldMaterial;
        }
    }
    ,
    OBSIDIAN((IArmorMaterial)APArmorProperties.OBSIDIAN_PROP, TextFormatting.DARK_GRAY, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.RESISTANCE, 1))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.obsidianMaterial;
        }
    }
    ,
    INFUSED_LAVA((IArmorMaterial)APArmorProperties.INFUSED_LAVA_PROP, true, TextFormatting.GOLD, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.FIRE_RESISTANCE, 0), new BuffInstance(Buff.FIRE_EXTINGUISH), new BuffInstance(Buff.WATER_WEAKNESS))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.infusedLavaMaterial;
        }
    }
    ,
    GUARDIAN((IArmorMaterial)APArmorProperties.GUARDIAN_PROP, true, TextFormatting.BLUE, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.WATER_BREATHING, 0))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.guardianMaterial;
        }
    }
    ,
    SUPER_STAR((IArmorMaterial)APArmorProperties.SUPER_STAR_PROP, true, TextFormatting.WHITE, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.WITHER_IMMUNITY), new BuffInstance(Buff.REGENERATION, 0), new BuffInstance(Buff.FIRE_RESISTANCE, 0), new BuffInstance(Buff.FIRE_EXTINGUISH))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.superStarMaterial;
        }
    }
    ,
    ENDER_DRAGON((IArmorMaterial)APArmorProperties.ENDER_DRAGON_PROP, true, TextFormatting.DARK_PURPLE, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.WITHER_IMMUNITY), new BuffInstance(Buff.FLIGHT), new BuffInstance(Buff.SLOW_FALLING, 0))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.enderDragonMaterial;
        }
    }
    ,
    ARDITE(APArmorProperties.ARDITE_PROP, TextFormatting.RED),
    COBALT(APArmorProperties.COBALT_PROP, TextFormatting.BLUE),
    KNIGHT_SLIME(APArmorProperties.KNIGHT_SLIME_PROP, TextFormatting.LIGHT_PURPLE),
    PIG_IRON(APArmorProperties.PIG_IRON_PROP, TextFormatting.LIGHT_PURPLE),
    MANYULLYN(APArmorProperties.MANYULLYN_PROP, TextFormatting.DARK_PURPLE),
    SLAYER((IArmorMaterial)APArmorProperties.SLAYER_PROP, true, TextFormatting.DARK_PURPLE, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.FIRE_RESISTANCE, 0), new BuffInstance(Buff.WITHER_IMMUNITY), new BuffInstance(Buff.FLIGHT), new BuffInstance(Buff.WATER_BREATHING, 0), new BuffInstance(Buff.SLOW_FALLING, 0), new BuffInstance(Buff.FIRE_EXTINGUISH))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.slayerMaterial;
        }
    }
    ,
    CHAINMAIL(APArmorProperties.ENHANCED_CHAINMAIL_PROP, TextFormatting.GRAY),
    GOLDEN(APArmorProperties.ENHANCED_GOLD_PROP, TextFormatting.GRAY),
    IRON(APArmorProperties.ENHANCED_IRON_PROP, TextFormatting.GRAY),
    DIAMOND(APArmorProperties.ENHANCED_DIAMOND_PROP, TextFormatting.GRAY),
    NETHERITE((IArmorMaterial)APArmorProperties.ENHANCED_NETHERITE_PROP, true, TextFormatting.GRAY, Collections::emptyList),
    FROST((IArmorMaterial)APArmorProperties.FROST_PROP, false, TextFormatting.BLUE, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.FIRE_WEAKNESS))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.frostMaterial;
        }
    }
    ,
    FROST_LAVA((IArmorMaterial)APArmorProperties.FROST_LAVA_PROP, true, TextFormatting.YELLOW, () -> APArmorMaterial.withBuffs(new BuffInstance(Buff.NATURAL_IMMUNITY))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.frostLavaMaterial;
        }
    };

    private final IArmorMaterial armor;
    private final boolean isImmuneToFire;
    private final Supplier<List<BuffInstance>> buffs;
    private final TextFormatting formatting;

    private APArmorMaterial() {
        this((IArmorMaterial)ArmorMaterial.IRON, false, TextFormatting.RESET, Collections::emptyList);
    }

    private APArmorMaterial(IArmorMaterial armor) {
        this(armor, false, TextFormatting.RESET, Collections::emptyList);
    }

    private APArmorMaterial(IArmorMaterial armor, TextFormatting formatting) {
        this(armor, false, formatting, Collections::emptyList);
    }

    private APArmorMaterial(IArmorMaterial armor, TextFormatting formatting, Supplier<List<BuffInstance>> buffs) {
        this(armor, false, formatting, buffs);
    }

    private APArmorMaterial(IArmorMaterial armor, boolean isImmuneToFire, TextFormatting formatting, Supplier<List<BuffInstance>> buffs) {
        this.armor = armor;
        this.isImmuneToFire = isImmuneToFire;
        this.buffs = buffs;
        this.formatting = formatting;
    }

    private static List<BuffInstance> withBuffs(BuffInstance ... buffs) {
        return Arrays.asList(buffs);
    }

    @Override
    public String getName() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public IArmorMaterial get() {
        return this.armor;
    }

    @Override
    public Item.Properties getProperties() {
        return new Item.Properties().func_200916_a(ArmorPlus.AP_GROUP).func_208103_a(Rarity.create((String)this.getName(), (TextFormatting)this.getFormatting()));
    }

    @Override
    public boolean isImmuneToFire() {
        return this.isImmuneToFire;
    }

    @Override
    public TextFormatting getFormatting() {
        return this.formatting;
    }

    @Override
    public Supplier<List<BuffInstance>> getBuffInstances() {
        return this.buffs;
    }

    public String toString() {
        return "APArmorMaterial{armor=" + this.armor + ", isImmuneToFire=" + this.isImmuneToFire + ", buffs=" + this.buffs + ", formatting=" + this.formatting + '}';
    }
}

