/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.items.armors;

import com.sofodev.armorplus.registry.items.armors.APRepair;
import com.sofodev.armorplus.utils.Utils;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum APArmorProperties implements IArmorMaterial
{
    COAL_PROP(2, new int[]{1, 1, 2, 1}, 8, SoundEvents.field_187728_s, new IItemProvider[]{Items.field_151044_h, Items.field_221896_ff}),
    REDSTONE_PROP(11, new int[]{1, 2, 3, 2}, 8, SoundEvents.field_187725_r, new IItemProvider[]{Items.field_151137_ax, Items.field_221858_em}),
    LAPIS_PROP(11, new int[]{1, 2, 3, 2}, 8, SoundEvents.field_187725_r, new IItemProvider[]{Items.field_196128_bn, Items.field_221654_ao}),
    CHICKEN_PROP(1, new int[]{1, 1, 2, 1}, 8, SoundEvents.field_187728_s, new IItemProvider[]{Items.field_151008_G}),
    SLIME_PROP(1, new int[]{1, 1, 2, 1}, 8, SoundEvents.field_187728_s, new IItemProvider[]{Items.field_151123_aH, Items.field_221904_fj}),
    EMERALD_PROP(35, new int[]{3, 6, 8, 3}, 16, SoundEvents.field_187716_o, 1.0f, new IItemProvider[]{Items.field_151166_bC, Items.field_221739_dF}),
    OBSIDIAN_PROP(40, new int[]{3, 6, 7, 3}, 16, SoundEvents.field_187716_o, 2.0f, new IItemProvider[]{Items.field_221655_bP}),
    INFUSED_LAVA_PROP(55, new int[]{3, 6, 8, 3}, 16, SoundEvents.field_187716_o, 1.0f, "infused_lava_crystal"),
    GUARDIAN_PROP(80, new int[]{4, 7, 8, 3}, 30, SoundEvents.field_232681_Q_, 2.0f, "guardian_scale"),
    SUPER_STAR_PROP(80, new int[]{4, 7, 8, 3}, 30, SoundEvents.field_232681_Q_, 2.0f, "wither_bone"),
    ENDER_DRAGON_PROP(80, new int[]{4, 7, 8, 3}, 30, SoundEvents.field_232681_Q_, 2.0f, "ender_dragon_scale"),
    ARDITE_PROP(55, new int[]{2, 3, 4, 2}, 16, SoundEvents.field_187725_r, 1.0f, new IItemProvider[]{Items.field_190931_a}),
    COBALT_PROP(44, new int[]{2, 3, 4, 2}, 16, SoundEvents.field_187725_r, 1.0f, new IItemProvider[]{Items.field_190931_a}),
    KNIGHT_SLIME_PROP(33, new int[]{2, 3, 4, 3}, 16, SoundEvents.field_187725_r, 1.0f, new IItemProvider[]{Items.field_190931_a}),
    PIG_IRON_PROP(33, new int[]{2, 3, 4, 3}, 16, SoundEvents.field_187725_r, 1.0f, new IItemProvider[]{Items.field_190931_a}),
    MANYULLYN_PROP(66, new int[]{3, 5, 5, 3}, 30, SoundEvents.field_232681_Q_, 2.0f, new IItemProvider[]{Items.field_190931_a}),
    SLAYER_PROP(169, new int[]{4, 8, 9, 4}, 60, SoundEvents.field_232681_Q_, 5.0f, "the_ultimate_material"),
    ENHANCED_CHAINMAIL_PROP(false, 20, new int[]{2, 5, 6, 3}, 15, SoundEvents.field_187713_n, 1.0f, "chainmail"),
    ENHANCED_GOLD_PROP(false, 10, new int[]{2, 4, 5, 2}, 30, SoundEvents.field_187722_q, 1.0f, new IItemProvider[]{Items.field_151043_k}),
    ENHANCED_IRON_PROP(false, 20, new int[]{2, 5, 6, 2}, 15, SoundEvents.field_187725_r, 2.0f, new IItemProvider[]{Items.field_151042_j}),
    ENHANCED_DIAMOND_PROP(false, 35, new int[]{3, 6, 7, 3}, 20, SoundEvents.field_187716_o, 3.0f, new IItemProvider[]{Items.field_151045_i}),
    ENHANCED_NETHERITE_PROP(false, 47, new int[]{3, 6, 8, 3}, 25, SoundEvents.field_232681_Q_, 4.0f, new IItemProvider[]{Items.field_234759_km_}),
    FROST_PROP(55, new int[]{3, 6, 8, 3}, 16, SoundEvents.field_187716_o, 1.0f, "infused_frost_crystal"),
    FROST_LAVA_PROP(70, new int[]{4, 7, 8, 3}, 32, SoundEvents.field_232681_Q_, 2.0f, new IItemProvider[]{Items.field_190931_a});

    private static final int[] MAX_DAMAGE_ARRAY;
    private final String name;
    private final int durability;
    private final float toughness;
    private final int[] damageReduction;
    private final int enchantability;
    private final SoundEvent soundEvent;
    private final APRepair repair;
    private final boolean special;

    private APArmorProperties(int durability, int[] damageReduction, int enchantability, SoundEvent soundEvent, IItemProvider ... repair) {
        this(true, durability, damageReduction, enchantability, soundEvent, 0.0f, repair);
    }

    private APArmorProperties(int durability, int[] damageReduction, int enchantability, SoundEvent soundEvent, float toughness, IItemProvider ... repair) {
        this(true, durability, damageReduction, enchantability, soundEvent, toughness, repair);
    }

    private APArmorProperties(boolean special, int durability, int[] damageReduction, int enchantability, SoundEvent soundEvent, float toughness, IItemProvider ... repair) {
        this(special, durability, damageReduction, enchantability, soundEvent, toughness, new APRepair(repair));
    }

    private APArmorProperties(int durability, int[] damageReduction, int enchantability, SoundEvent soundEvent, String ... repair) {
        this(true, durability, damageReduction, enchantability, soundEvent, 0.0f, repair);
    }

    private APArmorProperties(int durability, int[] damageReduction, int enchantability, SoundEvent soundEvent, float toughness, String ... repair) {
        this(true, durability, damageReduction, enchantability, soundEvent, toughness, repair);
    }

    private APArmorProperties(boolean special, int durability, int[] damageReduction, int enchantability, SoundEvent soundEvent, float toughness, String ... repair) {
        this(special, durability, damageReduction, enchantability, soundEvent, toughness, new APRepair(repair));
    }

    private APArmorProperties(boolean special, int durability, int[] damageReduction, int enchantability, SoundEvent soundEvent, float toughness, APRepair repair) {
        this.special = special;
        this.name = this.name().toLowerCase(Locale.ENGLISH).replace("_prop", "").replace("enhanced_", "");
        this.durability = durability;
        this.toughness = toughness;
        this.damageReduction = damageReduction;
        this.enchantability = enchantability;
        this.soundEvent = soundEvent;
        this.repair = repair;
    }

    public int func_200896_a(EquipmentSlotType slot) {
        return MAX_DAMAGE_ARRAY[slot.func_188454_b()] * this.durability;
    }

    public int func_200902_b(EquipmentSlotType slot) {
        return this.damageReduction[slot.func_188454_b()];
    }

    public int func_200900_a() {
        return this.enchantability;
    }

    public SoundEvent func_200899_b() {
        return this.soundEvent;
    }

    public Ingredient func_200898_c() {
        return Ingredient.func_234819_a_(Utils.getRepairStacks(this.repair).stream());
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_200897_d() {
        return this.special ? "armorplus:" + this.name : "minecraft:" + this.name;
    }

    public float func_200901_e() {
        return this.toughness;
    }

    public float func_230304_f_() {
        return this == ENHANCED_NETHERITE_PROP ? 0.1f : 0.0f;
    }

    public String toString() {
        return "APArmorProperties{name='" + this.name + '\'' + ", durability=" + this.durability + ", toughness=" + this.toughness + ", damageReduction=" + Arrays.toString(this.damageReduction) + ", enchantability=" + this.enchantability + ", soundEvent=" + this.soundEvent + ", repairMaterial=" + this.repair + ", special=" + this.special + '}';
    }

    static {
        MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    }
}

