/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.items.extras;

import com.sofodev.armorplus.registry.items.extras.IBuff;
import com.sofodev.armorplus.utils.Utils;
import java.util.Locale;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public enum Buff implements IBuff
{
    NONE,
    NIGHT_VISION,
    WATER_BREATHING,
    STRENGTH,
    SPEED,
    HASTE,
    JUMP_BOOST,
    REGENERATION,
    RESISTANCE,
    FIRE_RESISTANCE,
    SATURATION,
    INVISIBILITY,
    HEALTH_BOOST,
    ABSORPTION,
    SLOW_FALLING,
    FLIGHT(true){}
    ,
    WITHER_IMMUNITY(true){

        @Override
        public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
            if (!world.field_72995_K) {
                player.func_195063_d(Effects.field_82731_v);
            }
        }
    }
    ,
    WATER_WEAKNESS(true){

        @Override
        public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
            int supply;
            boolean water;
            if (!world.field_72995_K && (water = player.func_204231_K()) && (supply = player.func_70086_ai()) > 1 && supply <= player.func_205010_bg()) {
                player.func_70050_g(supply / 2);
            }
        }
    }
    ,
    FIRE_WEAKNESS(true){

        @Override
        public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
            boolean fire;
            if (!world.field_72995_K && (fire = player.func_70027_ad())) {
                player.func_241209_g_(player.func_223314_ad() + 5);
            }
        }
    }
    ,
    NATURAL_IMMUNITY(true){

        @Override
        public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
            if (!player.func_70644_a(FIRE_RESISTANCE.getEffect())) {
                player.func_195064_c(new EffectInstance(FIRE_RESISTANCE.getEffect(), 60, 0, false, false));
            }
            if (!player.func_70644_a(RESISTANCE.getEffect())) {
                player.func_195064_c(new EffectInstance(RESISTANCE.getEffect(), 60, 0, false, false));
            }
            if (!world.field_72995_K && player.func_223314_ad() > 0) {
                player.func_70066_B();
            }
        }
    }
    ,
    FIRE_EXTINGUISH(true){

        @Override
        public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
            if (!world.field_72995_K && player.func_223314_ad() > 0) {
                player.func_70066_B();
            }
        }
    };

    private final boolean isEffect;
    private final Effect effect;
    private final boolean requireFullSet;

    private Buff(boolean isEffect, boolean requireFullSet) {
        this.isEffect = isEffect;
        this.effect = (Effect)ForgeRegistries.POTIONS.getValue(Utils.setVanillaLocation(this.name().toLowerCase(Locale.ENGLISH)));
        this.requireFullSet = requireFullSet;
    }

    private Buff(boolean requireFullSet) {
        this(false, requireFullSet);
    }

    private Buff() {
        this(true, true);
    }

    @Override
    public boolean isEffect() {
        return this.isEffect;
    }

    @Override
    public Effect getEffect() {
        return this.effect;
    }

    @Override
    public boolean requiresFullSet() {
        return this.requireFullSet;
    }

    public String toString() {
        return "Buff{isEffect=" + this.isEffect + ", effect=" + this.effect + ", requireFullSet=" + this.requireFullSet + '}';
    }
}

