/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.items.extras;

import com.sofodev.armorplus.registry.items.extras.IBuff;
import com.sofodev.armorplus.utils.ToolTipUtils;
import com.sofodev.armorplus.utils.Utils;
import java.util.Locale;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.Potions;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class BuffInstance {
    private IBuff buff;
    private int amplifier;
    private final boolean instant;
    private final Potion potion;
    private boolean enabled;

    public BuffInstance(IBuff buff, int amplifier) {
        this(buff, amplifier, 20, true);
    }

    public BuffInstance(IBuff buff, int amplifier, int duration) {
        this(buff, amplifier, duration, false);
    }

    public BuffInstance(IBuff buff, int amplifier, int duration, boolean instant) {
        this.buff = buff;
        this.amplifier = amplifier;
        this.instant = instant;
        this.potion = buff.isEffect() && buff.getEffect() != null ? new Potion(new EffectInstance[]{new EffectInstance(buff.getEffect(), Utils.convertToSeconds(duration), amplifier, false, false)}) : Potions.field_185229_a;
        this.enabled = true;
    }

    public BuffInstance(IBuff buff) {
        this.buff = buff;
        this.amplifier = -1;
        this.instant = true;
        this.potion = Potions.field_185229_a;
        this.enabled = true;
    }

    public static BuffInstance build(IBuff buff, int amplifier, int duration, boolean instant) {
        return new BuffInstance(buff, amplifier, duration, instant);
    }

    public static BuffInstance build(IBuff buff, int amplifier, int duration) {
        return new BuffInstance(buff, amplifier, duration);
    }

    public static BuffInstance build(IBuff buff, int amplifier) {
        return new BuffInstance(buff, amplifier);
    }

    public static BuffInstance build(IBuff buff) {
        return new BuffInstance(buff);
    }

    public BuffInstance setBuff(IBuff buff) {
        this.buff = buff;
        return this;
    }

    public BuffInstance setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public BuffInstance setAmplifier(int amplifier) {
        this.amplifier = amplifier;
        return this;
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        this.buff.onArmorTick(stack, world, player);
        if (this.buff.isEffect()) {
            for (EffectInstance pot : this.getPotion().func_185170_a()) {
                if (!this.instant) {
                    if (player.func_70651_bq().contains(pot)) continue;
                    player.func_195064_c(pot);
                    continue;
                }
                player.func_195064_c(pot);
            }
        }
    }

    public void hitEntity(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.buff.hitEntity(stack, target, attacker);
        if (this.buff.isEffect()) {
            this.getPotion().func_185170_a().forEach(arg_0 -> ((LivingEntity)target).func_195064_c(arg_0));
        }
    }

    public Potion getPotion() {
        return this.potion;
    }

    public IBuff getBuff() {
        return this.buff;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public IFormattableTextComponent getTranslatedName() {
        String name = this.buff.name().toLowerCase(Locale.ENGLISH);
        return this.buff.isEffect() ? ToolTipUtils.translate(TextFormatting.DARK_AQUA, "armorplus.effect." + name, new Object[0]) : ToolTipUtils.translate(TextFormatting.DARK_AQUA, "armorplus.buff." + name, new Object[0]);
    }

    public String toString() {
        return "BuffInstance{buff=" + this.buff + ", amplifier=" + this.amplifier + ", instant=" + this.instant + ", potion=" + this.potion + ", enabled=" + this.enabled + '}';
    }
}

