/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.items.materials;

import com.sofodev.armorplus.registry.items.APItem;
import com.sofodev.armorplus.utils.ToolTipUtils;
import com.sofodev.armorplus.utils.Utils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class LavaCrystalItem
extends APItem {
    private final boolean isInfused;
    private int[] burnTime = new int[]{20000, 22000};

    public LavaCrystalItem(boolean isInfused) {
        super(new Item.Properties().func_234689_a_());
        this.isInfused = isInfused;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!this.isInfused) {
            tooltip.add((ITextComponent)ToolTipUtils.translate("tooltip.armorplus.lava_crystal.how_to_infuse", new Object[0]).func_230530_a_(Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true)).func_240718_a_(Color.func_240745_a_((String)"#670067"))));
        } else {
            tooltip.add((ITextComponent)ToolTipUtils.translate("tooltip.armorplus.lava_crystal.lore", new Object[0]).func_230530_a_(Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true)).func_240718_a_(Color.func_240745_a_((String)"#670067"))));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        boolean isInLava = entity.func_130014_f_().func_204610_c(entity.func_233580_cy_()).getFluidState().func_206884_a((ITag)FluidTags.field_206960_b);
        if (!this.isInfused && isInLava) {
            entity.func_199701_a_(new ItemStack((IItemProvider)Utils.getAPItem("infused_lava_crystal"), entity.func_92059_d().func_190916_E()));
            entity.func_92059_d().func_190920_e(0);
            return true;
        }
        return false;
    }

    public boolean func_234685_a_(DamageSource damageSource) {
        return super.func_234685_a_(damageSource);
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.create((String)"Lava Crystalic", (TextFormatting)TextFormatting.GOLD);
    }

    public int getBurnTime(ItemStack itemStack) {
        return this.isInfused ? this.burnTime[1] : this.burnTime[0];
    }

    public boolean isInfused() {
        return this.isInfused;
    }
}

