/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.items.tools;

import com.sofodev.armorplus.ArmorPlus;
import com.sofodev.armorplus.registry.items.tools.properties.mace.DestructionShape;
import com.sofodev.armorplus.registry.items.tools.properties.mace.IAPMace;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.IntStream;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.SwordItem;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.Animation;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class APMaceItem
extends SwordItem
implements IAnimatable {
    public final IAPMace mat;
    public AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public final String controllerName = "maceController";

    public APMaceItem(IAPMace mat, Item.Properties props) {
        super(mat.get(), (int)(mat.get().func_200929_c() + mat.getType().getDmg()), mat.getType().getAttackSpeed(), props.func_200916_a(ArmorPlus.AP_WEAPON_GROUP));
        this.mat = mat;
    }

    public static int getIDFromStack(ItemStack stack) {
        return Objects.hash(stack.func_77973_b(), stack.func_190916_E(), stack.func_77942_o() ? stack.func_77978_p().toString() : Integer.valueOf(1));
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return super.func_82789_a(toRepair, repair);
    }

    public boolean func_77651_p() {
        return super.func_77651_p();
    }

    public static AnimationController getControllerForStack(AnimationFactory factory, ItemStack stack, String controllerName) {
        return (AnimationController)factory.getOrCreateAnimationData(Integer.valueOf(GeckoLibUtil.getIDFromStack((ItemStack)stack))).getAnimationControllers().get(controllerName);
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    public Rarity func_77613_e(ItemStack stack) {
        return this.mat.getRarity();
    }

    public int func_77626_a(ItemStack stack) {
        return (int)this.mat.getType().getChargeSpeed() * 2000;
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity living, int timeLeft) {
        if (living instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)living;
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt != null && nbt.func_186855_b("key")) {
                AnimationController controller = GeckoLibUtil.getControllerForStack((AnimationFactory)this.factory, (ItemStack)stack, (String)this.controllerName);
                Animation currentAnimation = controller.getCurrentAnimation();
                int chargeTime = this.func_77626_a(stack) - timeLeft;
                if ((float)chargeTime >= this.mat.getType().getChargeSpeed()) {
                    if (currentAnimation != null) {
                        currentAnimation.loop = false;
                    }
                    if (world.field_72995_K) {
                        this.swingAnimation(controller);
                    } else {
                        boolean isOffHandEmpty = player.func_184582_a(EquipmentSlotType.OFFHAND).func_190926_b();
                        if (isOffHandEmpty) {
                            boolean isWestOrEast;
                            BlockPos destructionPos = new BlockPos(player.func_213303_ch());
                            Direction direction = player.func_184172_bi();
                            boolean isNorthOrSouth = direction == Direction.NORTH || direction == Direction.SOUTH;
                            boolean bl = isWestOrEast = direction == Direction.EAST || direction == Direction.WEST;
                            if (isNorthOrSouth) {
                                this.executeDestruction(player, this.mat, world, stack, destructionPos, direction, true);
                            } else if (isWestOrEast) {
                                this.executeDestruction(player, this.mat, world, stack, destructionPos, direction, false);
                            }
                        }
                    }
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = this.setTag(player.func_184586_b(hand));
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_186855_b("key")) {
            AnimationController controller = GeckoLibUtil.getControllerForStack((AnimationFactory)this.factory, (ItemStack)stack, (String)this.controllerName);
            if (world.field_72995_K) {
                this.chargeAnimation(controller);
                return ActionResult.func_226250_c_((Object)stack);
            }
        }
        if (stack.func_77952_i() >= stack.func_77958_k() - 1) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        player.func_184598_c(hand);
        return ActionResult.func_226249_b_((Object)stack);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        World world = entity.field_70170_p;
        ItemStack itemStack = this.setTag(stack);
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_186855_b("key")) {
            AnimationController controller = GeckoLibUtil.getControllerForStack((AnimationFactory)this.factory, (ItemStack)itemStack, (String)this.controllerName);
            if (world.field_72995_K && entity instanceof PlayerEntity) {
                this.swingAnimation(controller);
                return true;
            }
        }
        return true;
    }

    private ItemStack setTag(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        UUID randomUUID = UUID.randomUUID();
        if (tag == null) {
            tag = new CompoundNBT();
            tag.func_186854_a("key", randomUUID);
            stack.func_77982_d(tag);
        }
        if (!tag.func_186855_b("key")) {
            tag.func_186854_a("key", randomUUID);
        }
        stack.func_77982_d(tag);
        return stack;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.NONE;
    }

    public void chargeAnimation(AnimationController<?> controller) {
        if (controller.getAnimationState() == AnimationState.Stopped) {
            controller.setAnimation(new AnimationBuilder().addAnimation("animation.mace.charge", Boolean.valueOf(false)).addAnimation("animation.mace.hold_charge", Boolean.valueOf(true)));
        }
    }

    public void swingAnimation(AnimationController<?> controller) {
        if (controller.getAnimationState() == AnimationState.Stopped) {
            controller.markNeedsReload();
            controller.setAnimation(new AnimationBuilder().addAnimation("animation.mace.swing_attack", Boolean.valueOf(false)));
        }
    }

    private void executeDestruction(PlayerEntity player, IAPMace mat, World world, ItemStack stack, BlockPos destructionPos, Direction direction, boolean flag) {
        this.destroyBlocksInLineDirectional(mat, world, destructionPos, direction, flag);
        int damage = mat.destructionRange();
        stack.func_222118_a(field_77697_d.nextInt(damage) + damage * damage, (LivingEntity)player, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        player.func_184811_cZ().func_185145_a(stack.func_77973_b(), mat.cooldown() * 20);
        player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
    }

    private void destroyBlocksInLineDirectional(IAPMace mat, World world, BlockPos destructionPos, Direction direction, boolean isNorthOrSouth) {
        IntStream.range(0, mat.destructionRange()).forEach(offset -> {
            if (mat.hasAOEDestruction()) {
                BlockPos eastOrSouth;
                BlockPos westOrNorth = isNorthOrSouth ? destructionPos.func_177976_e() : destructionPos.func_177978_c();
                BlockPos blockPos = eastOrSouth = isNorthOrSouth ? destructionPos.func_177974_f() : destructionPos.func_177968_d();
                if (mat.getShape() == DestructionShape.SQUARE) {
                    this.destroyBlockInLine(world, destructionPos, direction, offset);
                    this.destroyBlockInLine(world, westOrNorth, direction, offset);
                    this.destroyBlockInLine(world, eastOrSouth, direction, offset);
                } else if (mat.getShape() == DestructionShape.PLUS) {
                    this.destroyBlockInLine(world, destructionPos, direction, offset);
                    this.destroyBlockSingleLine(world, westOrNorth, direction, offset);
                    this.destroyBlockSingleLine(world, eastOrSouth, direction, offset);
                }
            } else {
                this.destroyBlockSingleLine(world, destructionPos, direction, offset);
            }
        });
    }

    private void destroyBlockInLine(World world, BlockPos destructionPos, Direction direction, int offset) {
        BlockPos pos = this.directionalOffset(destructionPos, direction, offset);
        this.destroyBlock(world, pos);
        this.destroyBlock(world, pos.func_177984_a());
        this.destroyBlock(world, pos.func_177984_a().func_177984_a());
    }

    private void destroyBlockSingleLine(World world, BlockPos destructionPos, Direction direction, int i) {
        this.destroyBlock(world, this.directionalOffset(destructionPos, direction, i).func_177984_a());
    }

    private void destroyBlock(World world, BlockPos pos) {
        if (!BlockTags.field_219755_X.func_230235_a_((Object)world.func_180495_p(pos).func_177230_c())) {
            world.func_175655_b(pos, true);
        }
    }

    private BlockPos directionalOffset(BlockPos pos, Direction direction, int offset) {
        return pos.func_177967_a(direction, offset + 1);
    }

    private <P extends Item> PlayState predicate(AnimationEvent<P> event) {
        ItemStack stack;
        List stackData = event.getExtraDataOfType(ItemStack.class);
        if (!stackData.isEmpty() && !(stack = (ItemStack)stackData.get(0)).func_190926_b()) {
            return stack.func_82839_y() ? PlayState.STOP : PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, this.controllerName, 20.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

