/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.items.tools;

import com.sofodev.armorplus.ArmorPlus;
import com.sofodev.armorplus.config.ArmorPlusConfig;
import com.sofodev.armorplus.registry.items.tools.properties.tool.APToolType;
import com.sofodev.armorplus.registry.items.tools.properties.tool.IAPTool;
import com.sofodev.armorplus.registry.items.tools.properties.tool.Tool;
import com.sofodev.armorplus.utils.ToolTipUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.Rarity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class APPickaxeItem
extends PickaxeItem
implements Tool {
    public static Map<Block, IItemProvider> SMELTING_MAP = APPickaxeItem.registerSmeltingMap();
    private final IAPTool mat;

    public APPickaxeItem(IAPTool mat) {
        super(mat.get(), (int)(mat.get().func_200929_c() + APToolType.PICKAXE.getDmg()), APToolType.PICKAXE.getAttackSpeed(), new Item.Properties().func_200916_a(ArmorPlus.AP_WEAPON_GROUP));
        this.mat = mat;
    }

    private static Map<Block, IItemProvider> registerSmeltingMap() {
        HashMap<Block, IItemProvider> map = new HashMap<Block, IItemProvider>();
        List<? extends String> input = ArmorPlusConfig.autoSmeltingInput.get();
        List<? extends String> output = ArmorPlusConfig.autoSmeltingOutput.get();
        if (input.size() != output.size()) {
            throw new IllegalArgumentException("autoSmeltingInput and autoSmeltingOutput in config/ap_config.toml must have the same size!");
        }
        for (int i = 0; i < input.size(); ++i) {
            String entryInput = input.get(i);
            String entryOutput = output.get(i);
            Block fromBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(entryInput));
            Item toItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entryOutput));
            if (fromBlock != null && toItem != null) {
                map.put(fromBlock, (IItemProvider)toItem);
                continue;
            }
            ArmorPlus.LOGGER.error("Block with the registry name: " + entryInput + " or Item with the registry name: " + entryOutput + " don't exist. Failed to add auto smelt recipe");
        }
        return map;
    }

    public Rarity func_77613_e(ItemStack stack) {
        return this.mat.getRarity();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ToolTipUtils.addBuffInformation(this.mat, tooltip, "on_hit", false, this.mat.config().enableWeaponEffects.get());
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity player) {
        if (!player.field_70170_p.field_72995_K && this.mat.config().enableWeaponEffects.get().booleanValue()) {
            this.mat.onBlockMined(stack, world, state, pos, player);
        }
        return super.func_179218_a(stack, world, state, pos, player);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!target.field_70170_p.field_72995_K && this.mat.config().enableWeaponEffects.get().booleanValue()) {
            this.mat.getBuffInstances().get().forEach(instance -> instance.hitEntity(stack, target, attacker));
        }
        return super.func_77644_a(stack, target, attacker);
    }

    @Override
    public IAPTool getMat() {
        return this.mat;
    }
}

