/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.items.tools.properties.tool;

import com.sofodev.armorplus.config.ArmorPlusConfig;
import com.sofodev.armorplus.registry.items.APRarity;
import com.sofodev.armorplus.registry.items.extras.BuffInstance;
import com.sofodev.armorplus.registry.items.extras.DeBuff;
import com.sofodev.armorplus.registry.items.tools.APPickaxeItem;
import com.sofodev.armorplus.registry.items.tools.properties.tool.APToolProperties;
import com.sofodev.armorplus.registry.items.tools.properties.tool.IAPTool;
import com.sofodev.armorplus.utils.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public enum APToolMaterial implements IAPTool
{
    COAL_MAT(APRarity.COAL, (IItemTier)APToolProperties.COAL_PROP, () -> APToolMaterial.withBuffs(new BuffInstance(DeBuff.BLINDNESS, 0, 10))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.coalMaterial;
        }
    }
    ,
    REDSTONE_MAT(APRarity.REDSTONE, (IItemTier)APToolProperties.REDSTONE_PROP, () -> APToolMaterial.withBuffs(new BuffInstance(DeBuff.MINING_FATIGUE, 1, 10))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.redstoneMaterial;
        }
    }
    ,
    LAPIS_MAT(APRarity.LAPIS, (IItemTier)APToolProperties.LAPIS_PROP, () -> APToolMaterial.withBuffs(new BuffInstance(DeBuff.NAUSEA, 0, 10))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.lapisMaterial;
        }
    }
    ,
    EMERALD_MAT(APRarity.EMERALD, (IItemTier)APToolProperties.EMERALD_PROP, () -> APToolMaterial.withBuffs(new BuffInstance(DeBuff.SLOWNESS, 0, 20))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.emeraldMaterial;
        }
    }
    ,
    OBSIDIAN_MAT(APRarity.OBSIDIAN, (IItemTier)APToolProperties.OBSIDIAN_PROP, () -> APToolMaterial.withBuffs(new BuffInstance(DeBuff.WEAKNESS, 2, 20))){

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.obsidianMaterial;
        }
    }
    ,
    INFUSED_LAVA_MAT(APRarity.INFUSED_LAVA, (IItemTier)APToolProperties.INFUSED_LAVA_PROP, () -> APToolMaterial.withBuffs(new BuffInstance(DeBuff.IGNITE))){

        @Override
        public void onBlockMined(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity player) {
            if (player instanceof PlayerEntity) {
                APPickaxeItem.SMELTING_MAP.forEach((block, item) -> {
                    if (block == state.func_177230_c()) {
                        world.func_225521_a_(pos, false, (Entity)player);
                        Utils.spawnAtLocation((PlayerEntity)player, new ItemStack(item), pos);
                    }
                });
            }
        }

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.infusedLavaMaterial;
        }
    }
    ,
    GUARDIAN_MAT(APRarity.GUARDIAN, (IItemTier)APToolProperties.GUARDIAN_PROP, () -> APToolMaterial.withBuffs(new BuffInstance(DeBuff.WEAKNESS, 1, 4), new BuffInstance(DeBuff.NAUSEA, 1, 20))){

        @Override
        public void onBlockMined(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity player) {
        }

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.guardianMaterial;
        }
    }
    ,
    SUPER_STAR_MAT(APRarity.SUPER_STAR, (IItemTier)APToolProperties.SUPER_STAR_PROP, () -> APToolMaterial.withBuffs(new BuffInstance(DeBuff.WITHER, 1, 4), new BuffInstance(DeBuff.GLOWING, 0, 20))){

        @Override
        public void onBlockMined(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity player) {
            if (state == Blocks.field_150348_b.func_176223_P() && this.random.nextInt(3) == 1) {
                player.func_70099_a(new ItemStack((IItemProvider)Blocks.field_150424_aL, 1), 0.0f);
            }
            if (state == Blocks.field_150354_m.func_176223_P() && this.random.nextInt(3) == 1) {
                player.func_70099_a(new ItemStack((IItemProvider)Blocks.field_150425_aM, 1), 0.0f);
            }
        }

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.superStarMaterial;
        }
    }
    ,
    ENDER_DRAGON_MAT(APRarity.ENDER_DRAGON, (IItemTier)APToolProperties.ENDER_DRAGON_PROP, () -> APToolMaterial.withBuffs(new BuffInstance(DeBuff.WITHER, 3, 4), new BuffInstance(DeBuff.SLOWNESS, 1, 20))){

        @Override
        public void onBlockMined(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity player) {
            if (state == Blocks.field_150377_bs.func_176223_P() && this.random.nextInt(3) == 1) {
                player.func_70099_a(new ItemStack((IItemProvider)Items.field_151079_bi, 1), 0.0f);
            }
        }

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.enderDragonMaterial;
        }
    }
    ,
    SLAYER_MAT(APRarity.SLAYER, (IItemTier)APToolProperties.SLAYER_PROP, () -> APToolMaterial.withBuffs(new BuffInstance(DeBuff.WITHER, 3, 4), new BuffInstance(DeBuff.SLOWNESS, 1, 20), new BuffInstance(DeBuff.GLOWING, 0, 20), new BuffInstance(DeBuff.WEAKNESS, 1, 4), new BuffInstance(DeBuff.NAUSEA, 1, 20))){

        @Override
        public void onBlockMined(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity player) {
            if (state == Blocks.field_150377_bs.func_176223_P() && this.random.nextInt(3) == 1) {
                player.func_70099_a(new ItemStack((IItemProvider)Items.field_151079_bi, 1), 0.0f);
            }
            if (state == Blocks.field_150348_b.func_176223_P() && this.random.nextInt(3) == 1) {
                player.func_70099_a(new ItemStack((IItemProvider)Blocks.field_150424_aL, 1), 0.0f);
            }
            if (state == Blocks.field_150354_m.func_176223_P() && this.random.nextInt(3) == 1) {
                player.func_70099_a(new ItemStack((IItemProvider)Blocks.field_150425_aM, 1), 0.0f);
            }
        }

        @Override
        public ArmorPlusConfig.MaterialConfig config() {
            return ArmorPlusConfig.slayerMaterial;
        }
    };

    public final Random random = new Random();
    private final IItemTier properties;
    private final Supplier<List<BuffInstance>> buffs;
    private final Rarity rarity;

    private APToolMaterial(APRarity rarity, IItemTier properties, Supplier<List<BuffInstance>> buffs) {
        this(rarity.getRarity(), properties, buffs);
    }

    private APToolMaterial(APRarity rarity, IItemTier properties) {
        this(rarity.getRarity(), properties, Collections::emptyList);
    }

    private APToolMaterial(Rarity rarity, IItemTier properties, Supplier<List<BuffInstance>> buffs) {
        this.rarity = rarity;
        this.properties = properties;
        this.buffs = buffs;
    }

    private static List<BuffInstance> withBuffs(BuffInstance ... buffs) {
        return Arrays.asList(buffs);
    }

    @Override
    public IItemTier get() {
        return this.properties;
    }

    @Override
    public Supplier<List<BuffInstance>> getBuffInstances() {
        return this.buffs;
    }

    @Override
    public String getName() {
        return this.name().toLowerCase(Locale.ENGLISH).replace("_mat", "");
    }

    @Override
    public Rarity getRarity() {
        return this.rarity;
    }

    public String toString() {
        return "APToolMaterial{random=" + this.random + ", properties=" + this.properties + ", buffs=" + this.buffs + ", rarity=" + this.rarity + '}';
    }
}

