/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.utils;

import com.sofodev.armorplus.registry.items.extras.BuffInstance;
import com.sofodev.armorplus.registry.items.tools.properties.tool.IAPTool;
import com.sofodev.armorplus.utils.RomanNumeralUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ToolTipUtils {
    public static void showInfo(List<ITextComponent> tooltip, KeyBinding keyBinding, TextFormatting formatting) {
        tooltip.add((ITextComponent)ToolTipUtils.translate(TextFormatting.GRAY, "tooltip.armorplus.shift.showinfo", ToolTipUtils.translate(formatting, keyBinding.func_151464_g(), new Object[0])));
    }

    public static void appendArrowHoverText(List<ITextComponent> tooltip, ITextComponent effect, double damage, TextFormatting formatting) {
        KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_228046_af_;
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)ToolTipUtils.translate("tooltip.armorplus.arrow.ability_desc", effect));
            tooltip.add((ITextComponent)ToolTipUtils.translate("tooltip.armorplus.arrow.ability", damage));
        } else {
            ToolTipUtils.showInfo(tooltip, keyBindSneak, formatting);
        }
    }

    public static void addBuffInformation(IAPTool tool, List<ITextComponent> tooltip, String condition, boolean applyToSelf, boolean enabled) {
        if (!tool.getBuffInstances().get().isEmpty()) {
            tooltip.add((ITextComponent)ToolTipUtils.translate(TextFormatting.YELLOW, "tooltip.armorplus.condition", enabled ? "" : "(DISABLED)"));
            tooltip.add((ITextComponent)ToolTipUtils.translate(TextFormatting.GOLD, "tooltip.armorplus.condition." + condition, new Object[0]));
            tooltip.add((ITextComponent)ToolTipUtils.translate(TextFormatting.GREEN, "tooltip.armorplus." + (applyToSelf ? "provides" : "applies"), new Object[0]));
            for (BuffInstance buff : tool.getBuffInstances().get()) {
                int lvl = buff.getAmplifier() + 1;
                String theLvl = lvl > 0 ? " " + RomanNumeralUtil.generate(lvl) : "";
                tooltip.add((ITextComponent)ToolTipUtils.translate(TextFormatting.DARK_AQUA, "tooltip.armorplus.buff", buff.getTranslatedName(), theLvl));
            }
        }
    }

    public static void addExperimentalItemInformation(List<ITextComponent> tooltip) {
        tooltip.add((ITextComponent)ToolTipUtils.translate(TextFormatting.RED, "tooltip.armorplus.not_accessible", new Object[0]));
        tooltip.add((ITextComponent)ToolTipUtils.translate(TextFormatting.RED, "tooltip.armorplus.not_accessible.2", new Object[0]));
        tooltip.add((ITextComponent)ToolTipUtils.translate(TextFormatting.RED, "tooltip.armorplus.not_accessible.3", new Object[0]));
    }

    public static IFormattableTextComponent translate(Color color, String key, Object ... args) {
        return new TranslationTextComponent(key, args).func_230530_a_(Style.field_240709_b_.func_240718_a_(color));
    }

    public static IFormattableTextComponent translate(Style style, String key, Object ... args) {
        return new TranslationTextComponent(key, args).func_230530_a_(style);
    }

    public static IFormattableTextComponent translate(TextFormatting formatting, String key, Object ... args) {
        return new TranslationTextComponent(key, args).func_240699_a_(formatting);
    }

    public static TextComponent translate(String key, Object ... args) {
        return new TranslationTextComponent(key, args);
    }
}

