/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.atmospheric.common.world.gen.feature;

import com.google.common.collect.Lists;
import com.minecraftabnormals.abnormals_core.core.util.TreeUtil;
import com.minecraftabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.SaplingBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;

public class AspenTreeFeature
extends Feature<BaseTreeFeatureConfig> {
    public AspenTreeFeature(Codec<BaseTreeFeatureConfig> config) {
        super(config);
    }

    public boolean place(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos position, BaseTreeFeatureConfig config) {
        int height = 12 + rand.nextInt(4) + rand.nextInt(5) + rand.nextInt(6);
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= worldIn.func_217301_I()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + height; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.Mutable mutable = new BlockPos.Mutable();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_217301_I()) {
                            if (TreeUtil.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, (BlockPos)mutable.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (TreeUtil.isValidGround((IWorld)worldIn, (BlockPos)position.func_177977_b(), (SaplingBlock)((SaplingBlock)AtmosphericBlocks.ASPEN_SAPLING.get())) && position.func_177956_o() < worldIn.func_217301_I()) {
                TreeUtil.setDirtAt((IWorld)worldIn, (BlockPos)position.func_177977_b());
                ArrayList<BlockPos> logsPlaced = new ArrayList<BlockPos>();
                int logX = position.func_177958_n();
                int logZ = position.func_177952_p();
                int leafHeight = height - 7 - rand.nextInt(3) - rand.nextInt(3);
                int branchHeight = leafHeight - 2 - rand.nextInt(3);
                int bonusBranchHeight = branchHeight - 2 - rand.nextInt(3);
                for (int k1 = 0; k1 < height; ++k1) {
                    int logY = position.func_177956_o() + k1;
                    BlockPos blockpos = new BlockPos(logX, logY, logZ);
                    if (TreeUtil.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos)) {
                        TreeUtil.placeDirectionalLogAt((IWorldWriter)worldIn, (BlockPos)blockpos, (Direction)Direction.UP, (Random)rand, (BaseTreeFeatureConfig)config);
                        logsPlaced.add(blockpos);
                    }
                    if (k1 >= leafHeight) {
                        for (Direction direction : Direction.values()) {
                            if (direction.func_176740_k().func_176716_d() != Direction.Plane.HORIZONTAL) continue;
                            TreeUtil.placeLeafAt((IWorldGenerationReader)worldIn, (BlockPos)blockpos.func_177972_a(direction), (Random)rand, (BaseTreeFeatureConfig)config);
                            BlockPos offsetPos = blockpos.func_177972_a(direction).func_177972_a(direction.func_176746_e());
                            if (k1 <= leafHeight || k1 >= height - 1 || rand.nextInt(4) == 0 && !worldIn.func_180495_p(offsetPos.func_177977_b()).func_196958_f()) continue;
                            TreeUtil.placeLeafAt((IWorldGenerationReader)worldIn, (BlockPos)offsetPos, (Random)rand, (BaseTreeFeatureConfig)config);
                        }
                        if (k1 <= leafHeight + 1 || k1 >= height - 2) continue;
                        for (int k3 = -2; k3 <= 2; ++k3) {
                            for (int j4 = -2; j4 <= 2; ++j4) {
                                if (Math.abs(k3) == 2 && Math.abs(j4) == 2 || !rand.nextBoolean()) continue;
                                TreeUtil.placeLeafAt((IWorldGenerationReader)worldIn, (BlockPos)blockpos.func_177982_a(k3, 0, j4), (Random)rand, (BaseTreeFeatureConfig)config);
                            }
                        }
                        continue;
                    }
                    if ((k1 != branchHeight || branchHeight <= 3 || rand.nextInt(5) == 0) && (k1 != bonusBranchHeight || bonusBranchHeight <= 2 || rand.nextInt(3) == 0)) continue;
                    int branchSize = 1 + rand.nextInt(2);
                    if (rand.nextBoolean()) {
                        branchSize += 1 + rand.nextInt(2);
                    }
                    ArrayList usedDirections = Lists.newArrayList();
                    while (usedDirections.size() < branchSize) {
                        Direction randomDirection = Direction.Plane.HORIZONTAL.func_179518_a(rand);
                        if (usedDirections.contains(randomDirection)) continue;
                        usedDirections.add(randomDirection);
                    }
                    for (Direction direction : usedDirections) {
                        TreeUtil.placeLeafAt((IWorldGenerationReader)worldIn, (BlockPos)blockpos.func_177972_a(direction), (Random)rand, (BaseTreeFeatureConfig)config);
                    }
                }
                TreeUtil.placeLeafAt((IWorldGenerationReader)worldIn, (BlockPos)new BlockPos(logX, height + 4, logZ), (Random)rand, (BaseTreeFeatureConfig)config);
                return true;
            }
            return false;
        }
        return false;
    }
}

