/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.atmospheric.core.other;

import com.minecraftabnormals.abnormals_core.core.util.DataUtil;
import com.minecraftabnormals.atmospheric.core.registry.AtmosphericBiomes;
import com.minecraftabnormals.atmospheric.core.registry.AtmosphericFeatures;
import com.minecraftabnormals.atmospheric.core.registry.AtmosphericStructures;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Features;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atmospheric")
public class AtmosphericGeneration {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEarlyBiomeLoad(BiomeLoadingEvent event) {
        ResourceLocation biome = event.getName();
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        MobSpawnInfoBuilder spawns = event.getSpawns();
        if (biome == null) {
            return;
        }
        if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{AtmosphericBiomes.RAINFOREST.getKey(), AtmosphericBiomes.RAINFOREST_PLATEAU.getKey()})) {
            AtmosphericGeneration.withRainforestFeatures(generation, spawns);
        }
        if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{AtmosphericBiomes.RAINFOREST_MOUNTAINS.getKey()})) {
            AtmosphericGeneration.withRainforestMountainsFeatures(generation, spawns);
        }
        if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{AtmosphericBiomes.SPARSE_RAINFOREST_PLATEAU.getKey()})) {
            AtmosphericGeneration.withSparseRainforestPlateauFeatures(generation, spawns);
        }
        if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{AtmosphericBiomes.RAINFOREST_BASIN.getKey()})) {
            AtmosphericGeneration.withRainforestBasinFeatures(generation, spawns);
        }
        if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{AtmosphericBiomes.SPARSE_RAINFOREST_BASIN.getKey()})) {
            AtmosphericGeneration.withSparseRainforestBasinFeatures(generation, spawns);
        }
        if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{AtmosphericBiomes.DUNES.getKey(), AtmosphericBiomes.DUNES_HILLS.getKey()})) {
            AtmosphericGeneration.withDunesFeatures(generation, spawns);
        }
        if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{AtmosphericBiomes.ROCKY_DUNES.getKey(), AtmosphericBiomes.ROCKY_DUNES_HILLS.getKey()})) {
            AtmosphericGeneration.withRockyDunesFeatures(generation, spawns);
        }
        if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{AtmosphericBiomes.PETRIFIED_DUNES.getKey()})) {
            AtmosphericGeneration.withPetrifiedDunesFeatures(generation, spawns);
        }
        if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{AtmosphericBiomes.FLOURISHING_DUNES.getKey()})) {
            AtmosphericGeneration.withFlourishingDunesFeatures(generation, spawns);
        }
        if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{AtmosphericBiomes.HOT_SPRINGS.getKey()})) {
            AtmosphericGeneration.withHotSpringsFeatures(generation, spawns);
        }
    }

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        ResourceLocation biome = event.getName();
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        if (biome == null) {
            return;
        }
        if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{Biomes.field_76769_d, Biomes.field_76786_s})) {
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.YUCCA_TREE_DESERT);
        }
        if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{Biomes.field_185438_aj, Biomes.field_150607_aa})) {
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.YUCCA_TREE);
        }
        if (DataUtil.matchesKeys((ResourceLocation)biome, (RegistryKey[])new RegistryKey[]{Biomes.field_185435_ag, Biomes.field_185436_ah})) {
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.YUCCA_TREE_SAVANNA);
        }
    }

    public static void withBaseRainforestFeatures(BiomeGenerationSettingsBuilder builder, MobSpawnInfoBuilder spawns) {
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243717_aa((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243756_p((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243757_q((BiomeGenerationSettings.Builder)builder);
        AtmosphericGeneration.withRainforestFoliage((BiomeGenerationSettings.Builder)builder);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.PODZOL);
        DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)spawns);
        DefaultBiomeFeatures.func_243714_a((MobSpawnInfo.Builder)spawns);
        spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200783_W, 40, 1, 2));
        spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200724_aC, 8, 4, 4));
    }

    public static void withRainforestFeatures(BiomeGenerationSettingsBuilder builder, MobSpawnInfoBuilder spawns) {
        AtmosphericGeneration.withBaseRainforestFeatures(builder, spawns);
        AtmosphericGeneration.withRainforestWaterFoliage((BiomeGenerationSettings.Builder)builder);
        AtmosphericGeneration.withRainforestTrees((BiomeGenerationSettings.Builder)builder);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.ROSEWOOD_TREE);
    }

    public static void withRainforestMountainsFeatures(BiomeGenerationSettingsBuilder builder, MobSpawnInfoBuilder spawns) {
        AtmosphericGeneration.withBaseRainforestFeatures(builder, spawns);
        AtmosphericGeneration.withRainforestWaterFoliage((BiomeGenerationSettings.Builder)builder);
        AtmosphericGeneration.withRainforestTrees((BiomeGenerationSettings.Builder)builder);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.ROSEWOOD_TREE_EXTRA);
    }

    public static void withSparseRainforestPlateauFeatures(BiomeGenerationSettingsBuilder builder, MobSpawnInfoBuilder spawns) {
        AtmosphericGeneration.withBaseRainforestFeatures(builder, spawns);
        AtmosphericGeneration.withRainforestWaterFoliage((BiomeGenerationSettings.Builder)builder);
        AtmosphericGeneration.withSparseRainforestPlateauTrees((BiomeGenerationSettings.Builder)builder);
    }

    public static void withRainforestBasinFeatures(BiomeGenerationSettingsBuilder builder, MobSpawnInfoBuilder spawns) {
        AtmosphericGeneration.withBaseRainforestFeatures(builder, spawns);
        AtmosphericGeneration.withRainforestBasinWaterFoliage((BiomeGenerationSettings.Builder)builder);
        AtmosphericGeneration.withRainforestBasinTrees((BiomeGenerationSettings.Builder)builder);
    }

    public static void withSparseRainforestBasinFeatures(BiomeGenerationSettingsBuilder builder, MobSpawnInfoBuilder spawns) {
        AtmosphericGeneration.withBaseRainforestFeatures(builder, spawns);
        AtmosphericGeneration.withSparseRainforestBasinWaterFoliage((BiomeGenerationSettings.Builder)builder);
        AtmosphericGeneration.withSparseRainforestBasinTrees((BiomeGenerationSettings.Builder)builder);
    }

    public static void withBaseDunesFeatures(BiomeGenerationSettingsBuilder builder, MobSpawnInfoBuilder spawns) {
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243723_ag((BiomeGenerationSettings.Builder)builder);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243805_aD);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.PATCH_ARID_SPROUTS);
        builder.func_242516_a(AtmosphericStructures.Configured.ARID_SHRINE);
        DefaultBiomeFeatures.func_243743_f((MobSpawnInfo.Builder)spawns);
    }

    public static void withDunesFeatures(BiomeGenerationSettingsBuilder builder, MobSpawnInfoBuilder spawns) {
        AtmosphericGeneration.withBaseDunesFeatures(builder, spawns);
        builder.func_242513_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, AtmosphericFeatures.Configured.DUNE_ROCK);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.YUCCA_TREE);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.PATCH_YUCCA_FLOWER);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.PATCH_ALOE_VERA);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.PATCH_BARREL_CACTUS_DUNES);
    }

    public static void withFlourishingDunesFeatures(BiomeGenerationSettingsBuilder builder, MobSpawnInfoBuilder spawns) {
        AtmosphericGeneration.withBaseDunesFeatures(builder, spawns);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243807_aF);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.PATCH_GILIA);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.PATCH_DUNE_GRASS);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.YUCCA_TREE_BEEHIVE);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.YUCCA_TREE_BABY);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.PATCH_YUCCA_FLOWER_EXTRA);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.PATCH_ALOE_VERA_EXTRA);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.PATCH_BARREL_CACTUS_FLOURISHING_DUNES);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.DUNE_ROCK_EXTRA);
    }

    public static void withRockyDunesFeatures(BiomeGenerationSettingsBuilder builder, MobSpawnInfoBuilder spawns) {
        AtmosphericGeneration.withBaseDunesFeatures(builder, spawns);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.YUCCA_TREE_ROCKY_DUNES);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.PATCH_ALOE_VERA);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.PATCH_BARREL_CACTUS_ROCKY_DUNES);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.DUNE_ROCK_MANY);
    }

    public static void withPetrifiedDunesFeatures(BiomeGenerationSettingsBuilder builder, MobSpawnInfoBuilder spawns) {
        AtmosphericGeneration.withBaseDunesFeatures(builder, spawns);
        builder.func_242513_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, AtmosphericFeatures.Configured.DUNE_ROCK);
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, AtmosphericFeatures.Configured.FOSSIL_SURFACE);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.YUCCA_TREE_PETRIFIED);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.PATCH_BARREL_CACTUS_PETRIFIED_DUNES);
    }

    public static void withHotSpringsFeatures(BiomeGenerationSettingsBuilder builder, MobSpawnInfoBuilder spawns) {
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243756_p((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243757_q((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243762_v((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243706_T((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243759_s((BiomeGenerationSettings.Builder)builder);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243912_cE);
        DefaultBiomeFeatures.func_243714_a((MobSpawnInfo.Builder)spawns);
        spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200724_aC, 8, 4, 4));
        spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200736_ab, 4, 2, 3));
        spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_220356_B, 8, 2, 4));
        DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)spawns);
    }

    public static void withRainforestFoliage(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243812_aK);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243803_aB);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243788_N);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.PASSION_VINES);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243931_cn);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.PATCH_WARM_MONKEY_BRUSH);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.PATCH_HOT_MONKEY_BRUSH);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.PATCH_SCALDING_MONKEY_BRUSH);
    }

    public static void withRainforestWaterFoliage(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.PATCH_WATER_HYACINTH);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.PATCH_WATERLILLY_RAINFOREST);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243965_y);
    }

    public static void withRainforestTrees(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.OAK_TREE_RAINFOREST);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.MORADO_TREE);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.RAINFOREST_BUSH);
    }

    public static void withRainforestBasinTrees(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.OAK_TREE_RAINFOREST);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.RAINFOREST_BUSH);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.ROSEWOOD_WATER_TREE);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.MORADO_WATER_TREE);
    }

    public static void withSparseRainforestBasinTrees(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.OAK_TREE_RAINFOREST);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.RAINFOREST_BUSH);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.ROSEWOOD_WATER_TREE_SPARSE);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.MORADO_WATER_TREE_SPARSE);
    }

    public static void withSparseRainforestPlateauTrees(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.ROSEWOOD_TREE_SPARSE);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.MORADO_TREE_SPARSE);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.RAINFOREST_BUSH);
    }

    public static void withRainforestBasinWaterFoliage(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.PATCH_WATER_HYACINTH);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243810_aI);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243775_A);
    }

    public static void withSparseRainforestBasinWaterFoliage(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.Configured.PATCH_WATER_HYACINTH_SPARSE);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243810_aI);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243775_A);
    }
}

