/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.autumnity.client.renderer.entity;

import com.minecraftabnormals.autumnity.client.renderer.entity.model.SnailModel;
import com.minecraftabnormals.autumnity.common.entity.passive.SnailEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SnailRenderer
extends MobRenderer<SnailEntity, SnailModel<SnailEntity>> {
    private static final ResourceLocation SNAIL_TEXTURES = new ResourceLocation("autumnity", "textures/entity/snail/snail.png");
    private static final ResourceLocation SNAKE_SNAIL_TEXTURES = new ResourceLocation("autumnity", "textures/entity/snail/snake_snail.png");
    private static final ResourceLocation NAUTILUS_SNAIL_TEXTURES = new ResourceLocation("autumnity", "textures/entity/snail/nautilus_snail.png");

    public SnailRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new SnailModel(), 0.5f);
    }

    public ResourceLocation getTextureLocation(SnailEntity entity) {
        String s = TextFormatting.func_110646_a((String)entity.func_200200_C_().getString().toLowerCase());
        if (s != null) {
            if ("snake".equals(s) || "snakeblock".equals(s) || "snake block".equals(s) || "snailblock".equals(s) || "snail block".equals(s)) {
                return SNAKE_SNAIL_TEXTURES;
            }
            if ("nautilus".equals(s) || "nautilus snail".equals(s)) {
                return NAUTILUS_SNAIL_TEXTURES;
            }
        }
        return SNAIL_TEXTURES;
    }

    protected void setupRotations(SnailEntity entityLiving, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_225621_a_((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
        double d0 = entityLiving.getShakingAnim(partialTicks);
        double d1 = entityLiving.getShakingAnimTicks() > 0.0f ? 1.0 : -1.0;
        double d2 = Math.sin(6.3 * d0) * d1 * d0;
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(6.0f * (float)d2));
    }
}

