/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.autumnity.core.other;

import com.minecraftabnormals.abnormals_core.core.util.DataUtil;
import com.minecraftabnormals.autumnity.common.entity.projectile.TurkeyEggEntity;
import com.minecraftabnormals.autumnity.core.registry.AutumnityBlocks;
import com.minecraftabnormals.autumnity.core.registry.AutumnityItems;
import net.minecraft.block.Block;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class AutumnityCompat {
    public static final Item ENDER_TORCH = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("endergetic", "ender_torch"));
    public static final Item CURSED_TORCH = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("caverns_and_chasms", "cursed_torch"));
    public static final Block YUCCA_GATEAU = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("atmospheric", "yucca_gateau"));

    public static void registerCompat() {
        AutumnityCompat.registerCompostables();
        AutumnityCompat.registerFlammables();
        AutumnityCompat.registerDispenserBehaviors();
    }

    private static void registerCompostables() {
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AutumnityItems.FOUL_BERRIES.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AutumnityItems.FOUL_BERRY_PIPS.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AutumnityItems.PUMPKIN_BREAD.get()), (float)0.85f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AutumnityBlocks.AUTUMN_CROCUS.get()), (float)0.65f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AutumnityBlocks.PANCAKE.get()), (float)0.85f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AutumnityBlocks.LARGE_PUMPKIN_SLICE.get()), (float)0.65f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AutumnityBlocks.CARVED_LARGE_PUMPKIN_SLICE.get()), (float)0.65f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AutumnityBlocks.MAPLE_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AutumnityBlocks.YELLOW_MAPLE_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AutumnityBlocks.ORANGE_MAPLE_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AutumnityBlocks.RED_MAPLE_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AutumnityBlocks.MAPLE_SAPLING.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AutumnityBlocks.YELLOW_MAPLE_SAPLING.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AutumnityBlocks.ORANGE_MAPLE_SAPLING.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AutumnityBlocks.RED_MAPLE_SAPLING.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AutumnityBlocks.MAPLE_LEAF_CARPET.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AutumnityBlocks.YELLOW_MAPLE_LEAF_CARPET.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AutumnityBlocks.ORANGE_MAPLE_LEAF_CARPET.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AutumnityBlocks.RED_MAPLE_LEAF_CARPET.get()), (float)0.3f);
        DataUtil.registerCompostable((IItemProvider)((IItemProvider)AutumnityBlocks.FOUL_BERRY_SACK.get()), (float)1.0f);
    }

    private static void registerFlammables() {
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.FOUL_BERRY_BUSH_PIPS.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.FOUL_BERRY_BUSH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.TALL_FOUL_BERRY_BUSH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.AUTUMN_CROCUS.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.STRIPPED_MAPLE_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.STRIPPED_MAPLE_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.SAPPY_MAPLE_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.SAPPY_MAPLE_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_PLANKS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_STAIRS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_SLAB.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_FENCE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_FENCE_GATE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.YELLOW_MAPLE_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.ORANGE_MAPLE_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.RED_MAPLE_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_LEAF_CARPET.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.YELLOW_MAPLE_LEAF_CARPET.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.ORANGE_MAPLE_LEAF_CARPET.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.RED_MAPLE_LEAF_CARPET.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_HEDGE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.YELLOW_MAPLE_HEDGE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.ORANGE_MAPLE_HEDGE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.RED_MAPLE_HEDGE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_BEEHIVE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_VERTICAL_SLAB.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.VERTICAL_MAPLE_PLANKS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_BOOKSHELF.get()), (int)30, (int)20);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_POST.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.STRIPPED_MAPLE_POST.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.FOUL_BERRY_SACK.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.TURKEY_EGG_CRATE.get()), (int)5, (int)20);
    }

    private static void registerDispenserBehaviors() {
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)AutumnityItems.TURKEY_EGG.get()), (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

            protected ProjectileEntity func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                return (ProjectileEntity)Util.func_200696_a((Object)((Object)new TurkeyEggEntity(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c())), egg -> egg.func_213884_b(stackIn));
            }
        });
    }
}

