/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;

public class BeamRenderer {
    private static final ResourceLocation BEAM_TEXTURE = new ResourceLocation("textures/entity/end_gateway_beam.png");

    public static void renderLightBeam(MatrixStack matrices, IRenderTypeBuffer bufferIn, int age, float tick, int minY, int maxY, float[] colors, float alpha, float beamIn, float beamOut) {
        float red = colors[0];
        float green = colors[1];
        float blue = colors[2];
        int maxBY = minY + maxY;
        float delta = maxY < 0 ? tick : -tick;
        float fractDelta = MathHelper.func_226164_h_((float)(delta * 0.2f - (float)MathHelper.func_76141_d((float)(delta * 0.1f))));
        float xIn = -beamIn;
        float minV = MathHelper.func_76131_a((float)(fractDelta - 1.0f), (float)0.0f, (float)1.0f);
        float maxV = (float)maxY * (0.5f / beamIn) + minV;
        float rotation = ((float)age + tick) / 25.0f + 6.0f;
        IVertexBuilder iVertexBuilder = bufferIn.getBuffer(RenderType.func_228637_a_((ResourceLocation)BEAM_TEXTURE, (boolean)true));
        matrices.func_227860_a_();
        matrices.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(-rotation));
        BeamRenderer.renderBeam(matrices, iVertexBuilder, red, green, blue, alpha, minY, maxBY, beamIn, 0.0f, 0.0f, beamIn, 0.0f, xIn, xIn, 0.0f, 0.0f, 1.0f, minV, maxV);
        float xOut = -beamOut;
        maxV = (float)maxY + minV;
        BeamRenderer.renderBeam(matrices, iVertexBuilder, red, green, blue, alpha, minY, maxBY, xOut, xOut, beamOut, xOut, xOut, beamOut, beamOut, beamOut, 0.0f, 1.0f, minV, maxV);
        matrices.func_227865_b_();
    }

    private static void renderBeam(MatrixStack matrices, IVertexBuilder vertexBuilder, float red, float green, float blue, float alpha, int minY, int maxY, float x1, float d1, float x2, float d2, float x3, float d3, float x4, float d4, float minU, float maxU, float minV, float maxV) {
        MatrixStack.Entry entry = matrices.func_227866_c_();
        Matrix4f matrix4f = entry.func_227870_a_();
        Matrix3f matrix3f = entry.func_227872_b_();
        BeamRenderer.renderBeam(matrix4f, matrix3f, vertexBuilder, red, green, blue, alpha, maxY, minY, x1, d1, x2, d2, minU, maxU, minV, maxV);
        BeamRenderer.renderBeam(matrix4f, matrix3f, vertexBuilder, red, green, blue, alpha, maxY, minY, x4, d4, x3, d3, minU, maxU, minV, maxV);
        BeamRenderer.renderBeam(matrix4f, matrix3f, vertexBuilder, red, green, blue, alpha, maxY, minY, x2, d2, x4, d4, minU, maxU, minV, maxV);
        BeamRenderer.renderBeam(matrix4f, matrix3f, vertexBuilder, red, green, blue, alpha, maxY, minY, x3, d3, x1, d1, minU, maxU, minV, maxV);
    }

    private static void renderBeam(Matrix4f matrix4f, Matrix3f matrix3f, IVertexBuilder vertexBuilder, float red, float green, float blue, float alpha, int minY, int maxY, float minX, float minD, float maxX, float maxD, float minU, float maxU, float minV, float maxV) {
        BeamRenderer.addVertex(matrix4f, matrix3f, vertexBuilder, red, green, blue, alpha, maxX, minY, maxD, maxU, minV);
        BeamRenderer.addVertex(matrix4f, matrix3f, vertexBuilder, red, green, blue, alpha, maxX, maxY, maxD, maxU, maxV);
        BeamRenderer.addVertex(matrix4f, matrix3f, vertexBuilder, red, green, blue, alpha, minX, maxY, minD, minU, maxV);
        BeamRenderer.addVertex(matrix4f, matrix3f, vertexBuilder, red, green, blue, alpha, minX, minY, minD, minU, minV);
    }

    private static void addVertex(Matrix4f matrix4f, Matrix3f matrix3f, IVertexBuilder vertexBuilder, float red, float green, float blue, float alpha, float x, float y, float d, float u, float v) {
        vertexBuilder.func_227888_a_(matrix4f, x, y, d).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
    }
}

