/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.block;

import java.util.Random;
import mod.beethoven92.betterendforge.common.block.BlockProperties;
import mod.beethoven92.betterendforge.common.init.ModParticleTypes;
import mod.beethoven92.betterendforge.common.interfaces.TeleportingEntity;
import mod.beethoven92.betterendforge.common.teleporter.BetterEndTeleporter;
import mod.beethoven92.betterendforge.common.teleporter.EndPortals;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;

public class EndPortalBlock
extends NetherPortalBlock {
    public static final IntegerProperty PORTAL = BlockProperties.PORTAL;

    public EndPortalBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        double x = (double)pos.func_177958_n() + rand.nextDouble();
        double y = (double)pos.func_177956_o() + rand.nextDouble();
        double z = (double)pos.func_177952_p() + rand.nextDouble();
        int k = rand.nextInt(2) * 2 - 1;
        if (!worldIn.func_180495_p(pos.func_177976_e()).func_203425_a((Block)this) && !worldIn.func_180495_p(pos.func_177974_f()).func_203425_a((Block)this)) {
            x = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)k;
        } else {
            z = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)k;
        }
        worldIn.func_195594_a((IParticleData)ModParticleTypes.PORTAL_SPHERE.get(), x, y, z, 0.0, 0.0, 0.0);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return stateIn;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (worldIn instanceof ServerWorld && !entityIn.func_184218_aH() && !entityIn.func_184207_aI() && entityIn.func_184222_aU()) {
            ServerWorld destination;
            TeleportingEntity teleEntity = (TeleportingEntity)TeleportingEntity.class.cast(entityIn);
            if (entityIn.func_242280_ah()) {
                return;
            }
            boolean isOverworld = worldIn.func_234923_W_().equals(World.field_234918_g_);
            MinecraftServer server = ((ServerWorld)worldIn).func_73046_m();
            ServerWorld serverWorld = destination = isOverworld ? server.func_71218_a(World.field_234920_i_) : EndPortals.getWorld(server, (Integer)state.func_177229_b((Property)PORTAL));
            if (destination == null) {
                return;
            }
            BlockPos exitPos = this.findExitPos(destination, pos, entityIn);
            if (exitPos == null) {
                return;
            }
            if (entityIn instanceof ServerPlayerEntity) {
                ServerPlayerEntity player = (ServerPlayerEntity)entityIn;
                player.changeDimension(destination, (ITeleporter)new BetterEndTeleporter(exitPos));
                player.func_242279_ag();
            } else {
                teleEntity.beSetExitPos(exitPos);
                entityIn.func_241206_a_(destination);
                if (entityIn != null) {
                    entityIn.func_242279_ag();
                }
            }
        }
    }

    private BlockPos findExitPos(ServerWorld world, BlockPos pos, Entity entity) {
        DimensionType type = world.func_230315_m_();
        double mult = type.func_242724_f();
        BlockPos.Mutable basePos = !world.func_234923_W_().equals(World.field_234920_i_) ? pos.func_239590_i_().func_189532_c((double)pos.func_177958_n() / mult, (double)pos.func_177956_o(), (double)pos.func_177952_p() / mult) : pos.func_239590_i_().func_189532_c((double)pos.func_177958_n() * mult, (double)pos.func_177956_o(), (double)pos.func_177952_p() * mult);
        Direction direction = Direction.EAST;
        BlockPos.Mutable checkPos = basePos.func_239590_i_();
        for (int step = 1; step < 128; ++step) {
            for (int i = 0; i < step >> 1; ++i) {
                int ceil;
                IChunk chunk = world.func_217349_x((BlockPos)checkPos);
                if (chunk != null && (ceil = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, checkPos.func_177958_n() & 0xF, checkPos.func_177952_p() & 0xF)) > 5) {
                    checkPos.func_185336_p(ceil);
                    while (checkPos.func_177956_o() > 5) {
                        BlockState state = world.func_180495_p((BlockPos)checkPos);
                        if (state.func_203425_a((Block)this)) {
                            Direction.Axis axis = (Direction.Axis)state.func_177229_b((Property)field_176550_a);
                            checkPos = this.findCenter((World)world, checkPos, axis);
                            Direction frontDir = Direction.func_211699_a((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE).func_176746_e();
                            Direction entityDir = entity.func_174811_aO();
                            if (entityDir.func_176740_k().func_200128_b()) {
                                entityDir = frontDir;
                            }
                            if (frontDir == entityDir || frontDir.func_176734_d() == entityDir) {
                                return checkPos.func_177972_a(entityDir);
                            }
                            entity.func_184229_a(Rotation.CLOCKWISE_90);
                            entityDir = entityDir.func_176746_e();
                            return checkPos.func_177972_a(entityDir);
                        }
                        checkPos.func_189536_c(Direction.DOWN);
                    }
                }
                checkPos.func_189536_c(direction);
            }
            direction = direction.func_176746_e();
        }
        return null;
    }

    private BlockPos.Mutable findCenter(World world, BlockPos.Mutable pos, Direction.Axis axis) {
        return this.findCenter(world, pos, axis, 1);
    }

    private BlockPos.Mutable findCenter(World world, BlockPos.Mutable pos, Direction.Axis axis, int step) {
        if (step > 8) {
            return pos;
        }
        Direction rightDir = Direction.func_211699_a((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        Direction leftDir = rightDir.func_176734_d();
        BlockState right = world.func_180495_p(pos.func_177972_a(rightDir));
        BlockState left = world.func_180495_p(pos.func_177972_a(leftDir));
        BlockState down = world.func_180495_p(pos.func_177977_b());
        if (down.func_203425_a((Block)this)) {
            return this.findCenter(world, pos.func_189536_c(Direction.DOWN), axis, step);
        }
        if (right.func_203425_a((Block)this) && left.func_203425_a((Block)this)) {
            return pos;
        }
        if (right.func_203425_a((Block)this)) {
            return this.findCenter(world, pos.func_189536_c(rightDir), axis, ++step);
        }
        if (left.func_203425_a((Block)this)) {
            return this.findCenter(world, pos.func_189536_c(leftDir), axis, ++step);
        }
        return pos;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{PORTAL});
    }
}

