/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.block.material;

import java.util.function.Supplier;
import mod.beethoven92.betterendforge.client.renderer.ChestItemTileEntityRenderer;
import mod.beethoven92.betterendforge.common.block.EndBarrelBlock;
import mod.beethoven92.betterendforge.common.block.EndSignBlock;
import mod.beethoven92.betterendforge.common.block.ModCraftingTableBlock;
import mod.beethoven92.betterendforge.common.block.template.BarkBlockTemplate;
import mod.beethoven92.betterendforge.common.block.template.PillarBlockTemplate;
import mod.beethoven92.betterendforge.common.block.template.StripableBarkBlockTemplate;
import mod.beethoven92.betterendforge.common.block.template.StripableLogBlockTemplate;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModCreativeTabs;
import mod.beethoven92.betterendforge.common.init.ModItems;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.init.ModTileEntityTypes;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.fml.RegistryObject;

public class WoodenMaterial {
    public final String name;
    public final RegistryObject<Block> log;
    public final RegistryObject<Block> bark;
    public final RegistryObject<Block> log_stripped;
    public final RegistryObject<Block> bark_stripped;
    public final RegistryObject<Block> planks;
    public final RegistryObject<Block> stairs;
    public final RegistryObject<Block> slab;
    public final RegistryObject<Block> fence;
    public final RegistryObject<Block> gate;
    public final RegistryObject<Block> button;
    public final RegistryObject<Block> pressurePlate;
    public final RegistryObject<Block> trapdoor;
    public final RegistryObject<Block> door;
    public final RegistryObject<Block> craftingTable;
    public final RegistryObject<Block> ladder;
    public final RegistryObject<Block> sign;
    public final RegistryObject<Block> chest;
    public final RegistryObject<Block> barrel;
    public final RegistryObject<Block> shelf;
    public final RegistryObject<Block> composter;
    public final ITag.INamedTag<Block> logBlockTag;
    public final ITag.INamedTag<Item> logItemTag;

    public WoodenMaterial(String name, MaterialColor woodColor, MaterialColor planksColor) {
        this.name = name;
        this.logBlockTag = ModTags.makeModBlockTag(name + "_logs");
        this.logItemTag = ModTags.makeModItemTag(name + "_logs");
        AbstractBlock.Properties materialPlanks = AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)planksColor).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a);
        AbstractBlock.Properties materialPlanksNotSolid = AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)planksColor).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_();
        this.log_stripped = ModBlocks.registerBlockWithDefaultItem(name + "_stripped_log", () -> new PillarBlockTemplate(materialPlanks));
        this.bark_stripped = ModBlocks.registerBlockWithDefaultItem(name + "_stripped_bark", () -> new BarkBlockTemplate(materialPlanks));
        this.log = ModBlocks.registerBlockWithDefaultItem(name + "_log", () -> new StripableLogBlockTemplate(woodColor, (Block)this.log_stripped.get()));
        this.bark = ModBlocks.registerBlockWithDefaultItem(name + "_bark", () -> new StripableBarkBlockTemplate(woodColor, (Block)this.bark_stripped.get()));
        this.planks = ModBlocks.registerBlockWithDefaultItem(name + "_planks", () -> new Block(materialPlanks));
        this.stairs = ModBlocks.registerBlockWithDefaultItem(name + "_stairs", () -> new StairsBlock(() -> ((Block)this.planks.get()).func_176223_P(), materialPlanks));
        this.slab = ModBlocks.registerBlockWithDefaultItem(name + "_slab", () -> new SlabBlock(materialPlanks));
        this.fence = ModBlocks.registerBlockWithDefaultItem(name + "_fence", () -> new FenceBlock(materialPlanks));
        this.gate = ModBlocks.registerBlockWithDefaultItem(name + "_gate", () -> new FenceGateBlock(materialPlanks));
        this.button = ModBlocks.registerBlockWithDefaultItem(name + "_button", () -> new WoodButtonBlock(materialPlanks));
        this.pressurePlate = ModBlocks.registerBlockWithDefaultItem(name + "_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, materialPlanks));
        this.trapdoor = ModBlocks.registerBlockWithDefaultItem(name + "_trapdoor", () -> new TrapDoorBlock(materialPlanksNotSolid));
        this.door = ModBlocks.registerBlockWithDefaultItem(name + "_door", () -> new DoorBlock(materialPlanksNotSolid));
        this.composter = WoodenMaterial.registerBlockWithBurnItem(name + "_composter", () -> new ComposterBlock(materialPlanksNotSolid), 300);
        this.craftingTable = WoodenMaterial.registerBlockWithBurnItem(name + "_crafting_table", () -> new ModCraftingTableBlock(materialPlanks), 300);
        this.ladder = WoodenMaterial.registerBlockWithBurnItem(name + "_ladder", () -> new LadderBlock(materialPlanksNotSolid), 300);
        this.chest = ModBlocks.registerBlock(name + "_chest", () -> new ChestBlock(materialPlanksNotSolid, () -> (TileEntityType)ModTileEntityTypes.CHEST.get()){

            public TileEntity createTileEntity(BlockState state, IBlockReader world) {
                return ((TileEntityType)ModTileEntityTypes.CHEST.get()).func_200968_a();
            }
        });
        ModItems.ITEMS.register(name + "_chest", () -> new BlockItem((Block)this.chest.get(), new Item.Properties().func_200916_a((ItemGroup)ModCreativeTabs.CREATIVE_TAB).setISTER(() -> ChestItemTileEntityRenderer::new)){

            public int getBurnTime(ItemStack itemStack) {
                return 300;
            }
        });
        this.sign = WoodenMaterial.registerBlockWithBurnItem(name + "_sign", () -> new EndSignBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)planksColor).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_200942_a()), 200);
        this.barrel = WoodenMaterial.registerBlockWithBurnItem(name + "_barrel", () -> new EndBarrelBlock(materialPlanksNotSolid), 300);
        this.shelf = WoodenMaterial.registerBlockWithBurnItem(name + "_bookshelf", () -> new Block(materialPlanks){

            public float getEnchantPowerBonus(BlockState state, IWorldReader world, BlockPos pos) {
                return 1.0f;
            }
        }, 300);
    }

    public boolean isTreeLog(Block block) {
        return block == this.log.get() || block == this.bark.get();
    }

    public boolean isTreeLog(BlockState state) {
        return this.isTreeLog(state.func_177230_c());
    }

    private static <T extends Block> RegistryObject<T> registerBlockWithBurnItem(String name, Supplier<? extends T> blockSupplier, final int burnTime) {
        RegistryObject block = ModBlocks.BLOCKS.register(name, blockSupplier);
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a((ItemGroup)ModCreativeTabs.CREATIVE_TAB)){

            public int getBurnTime(ItemStack itemStack) {
                return burnTime;
            }
        });
        return block;
    }
}

