/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.entity;

import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import mod.beethoven92.betterendforge.BetterEnd;
import mod.beethoven92.betterendforge.common.block.BlockProperties;
import mod.beethoven92.betterendforge.common.block.SilkMothNestBlock;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModEntityTypes;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public class SilkMothEntity
extends AnimalEntity
implements IFlyingAnimal {
    private BlockPos hivePos;
    private BlockPos entrance;
    private World hiveWorld;

    public SilkMothEntity(EntityType<? extends SilkMothEntity> entityType, World world) {
        super(entityType, world);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 20, true);
        this.field_70749_g = new MothLookControl((MobEntity)this);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.field_70728_aV = 1;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return LivingEntity.func_233639_cI_().func_233815_a_(Attributes.field_233818_a_, 2.0).func_233815_a_(Attributes.field_233819_b_, 16.0).func_233815_a_(Attributes.field_233822_e_, 0.4).func_233815_a_(Attributes.field_233821_d_, 0.1);
    }

    public void setHive(World world, BlockPos hive) {
        this.hivePos = hive;
        this.hiveWorld = world;
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        if (this.hivePos != null) {
            tag.func_218657_a("HivePos", (INBT)NBTUtil.func_186859_a((BlockPos)this.hivePos));
            tag.func_74778_a("HiveWorld", this.hiveWorld.func_234923_W_().func_240901_a_().toString());
        }
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("HivePos")) {
            this.hivePos = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("HivePos"));
            ResourceLocation worldID = new ResourceLocation(tag.func_74779_i("HiveWorld"));
            try {
                this.hiveWorld = this.field_70170_p.func_73046_m().func_71218_a(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)worldID));
            }
            catch (Exception e) {
                BetterEnd.LOGGER.warn("Silk Moth Hive World {} is missing!", (Object)worldID);
                this.hivePos = null;
            }
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new ReturnToHiveGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(8, (Goal)new WanderAroundGoal());
        this.field_70714_bg.func_75776_a(9, (Goal)new SwimGoal((MobEntity)this));
    }

    protected PathNavigator func_175447_b(World world) {
        FlyingPathNavigator birdNavigation = new FlyingPathNavigator((MobEntity)this, world){

            public boolean func_188555_b(BlockPos pos) {
                BlockState state = this.field_75513_b.func_180495_p(pos);
                return state.func_196958_f() || !state.func_185904_a().func_76230_c();
            }

            public void func_75501_e() {
                super.func_75501_e();
            }
        };
        birdNavigation.func_192878_b(false);
        birdNavigation.func_212239_d(false);
        birdNavigation.func_192879_a(true);
        return birdNavigation;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected boolean func_191957_ae() {
        return true;
    }

    public boolean func_225503_b_(float fallDistance, float damageMultiplier) {
        return false;
    }

    public boolean func_225502_at_() {
        return false;
    }

    public boolean func_189652_ae() {
        return true;
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity entity) {
        return (AgeableEntity)((EntityType)ModEntityTypes.SILK_MOTH.get()).func_200721_a((World)world);
    }

    public static boolean canSpawn(EntityType<SilkMothEntity> type, IServerWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        int y = world.func_217349_x(pos).func_201576_a(Heightmap.Type.WORLD_SURFACE, pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF);
        return y > 0 && pos.func_177956_o() >= y;
    }

    class ReturnToHiveGoal
    extends Goal {
        ReturnToHiveGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return SilkMothEntity.this.hivePos != null && SilkMothEntity.this.hiveWorld == SilkMothEntity.this.field_70170_p && SilkMothEntity.this.field_70699_by.func_75500_f() && SilkMothEntity.this.field_70146_Z.nextInt(16) == 0 && SilkMothEntity.this.func_213303_ch().func_186679_c((double)SilkMothEntity.this.hivePos.func_177958_n(), (double)SilkMothEntity.this.hivePos.func_177956_o(), (double)SilkMothEntity.this.hivePos.func_177952_p()) < 32.0;
        }

        public boolean func_75253_b() {
            return SilkMothEntity.this.field_70699_by.func_226337_n_() && SilkMothEntity.this.field_70170_p.func_180495_p(SilkMothEntity.this.entrance).func_196958_f() && SilkMothEntity.this.field_70170_p.func_180495_p(SilkMothEntity.this.hivePos).func_203425_a((Block)ModBlocks.SILK_MOTH_NEST.get());
        }

        public void func_75249_e() {
            BlockState state = SilkMothEntity.this.field_70170_p.func_180495_p(SilkMothEntity.this.hivePos);
            if (!state.func_203425_a((Block)ModBlocks.SILK_MOTH_NEST.get())) {
                SilkMothEntity.this.hivePos = null;
                SilkMothEntity.this.entrance = null;
            } else {
                SilkMothEntity.this.entrance = SilkMothEntity.this.hivePos.func_177972_a((Direction)state.func_177229_b((Property)SilkMothNestBlock.FACING));
                SilkMothEntity.this.field_70699_by.func_75484_a(SilkMothEntity.this.field_70699_by.func_179680_a(SilkMothEntity.this.entrance, 1), 1.0);
            }
        }

        public void func_75246_d() {
            if (SilkMothEntity.this.hivePos != null && SilkMothEntity.this.entrance != null) {
                BlockState state;
                super.func_75246_d();
                double dx = Math.abs((double)SilkMothEntity.this.entrance.func_177958_n() - SilkMothEntity.this.func_226277_ct_());
                double dy = Math.abs((double)SilkMothEntity.this.entrance.func_177956_o() - SilkMothEntity.this.func_226278_cu_());
                double dz = Math.abs((double)SilkMothEntity.this.entrance.func_177952_p() - SilkMothEntity.this.func_226281_cx_());
                if (dx + dy + dz < 1.0 && (state = SilkMothEntity.this.field_70170_p.func_180495_p(SilkMothEntity.this.hivePos)).func_203425_a((Block)ModBlocks.SILK_MOTH_NEST.get())) {
                    int fullness = (Integer)state.func_177229_b((Property)BlockProperties.FULLNESS);
                    if (fullness < 3 && SilkMothEntity.this.field_70146_Z.nextBoolean()) {
                        ++fullness;
                        BlockHelper.setWithUpdate((IWorldWriter)SilkMothEntity.this.hiveWorld, SilkMothEntity.this.hivePos, state);
                    }
                    SilkMothEntity.this.field_70170_p.func_184133_a(null, SilkMothEntity.this.entrance, SoundEvents.field_226131_af_, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    SilkMothEntity.this.func_70106_y();
                }
            }
        }
    }

    class WanderAroundGoal
    extends Goal {
        WanderAroundGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return SilkMothEntity.this.field_70699_by.func_75500_f() && SilkMothEntity.this.field_70146_Z.nextInt(10) == 0;
        }

        public boolean func_75253_b() {
            return SilkMothEntity.this.field_70699_by.func_226337_n_();
        }

        public void func_75249_e() {
            Vector3d vec3d = this.getRandomLocation();
            if (vec3d != null) {
                try {
                    SilkMothEntity.this.field_70699_by.func_75484_a(SilkMothEntity.this.field_70699_by.func_179680_a(new BlockPos(vec3d), 1), 1.0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Nullable
        private Vector3d getRandomLocation() {
            Vector3d vec3d3 = SilkMothEntity.this.func_70676_i(0.0f);
            Vector3d vec3d4 = RandomPositionGenerator.func_226340_a_((CreatureEntity)SilkMothEntity.this, (int)8, (int)7, (Vector3d)vec3d3, (float)1.5707964f, (int)2, (int)1);
            return vec3d4 != null ? vec3d4 : RandomPositionGenerator.func_226338_a_((CreatureEntity)SilkMothEntity.this, (int)8, (int)4, (int)-2, (Vector3d)vec3d3, (double)1.5707963705062866);
        }
    }

    class MothLookControl
    extends LookController {
        MothLookControl(MobEntity entity) {
            super(entity);
        }

        protected boolean func_220680_b() {
            return true;
        }
    }
}

