/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.event.forge;

import mod.beethoven92.betterendforge.common.init.ModBiomes;
import mod.beethoven92.betterendforge.common.init.ModConfiguredFeatures;
import mod.beethoven92.betterendforge.common.init.ModConfiguredStructures;
import mod.beethoven92.betterendforge.common.world.generator.GeneratorOptions;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ChorusPlantFeature;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="betterendforge")
public class BiomeModification {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void addFeaturesToEndBiomes(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.THEEND) {
            if (event.getName() == null) {
                return;
            }
            if (!event.getName().func_110623_a().contains("mountain") && !event.getName().func_110623_a().contains("lake")) {
                event.getGeneration().getStructures().add(() -> ModConfiguredStructures.ETERNAL_PORTAL);
            }
            event.getGeneration().getFeatures(GenerationStage.Decoration.SURFACE_STRUCTURES).add(() -> ModConfiguredFeatures.CRASHED_SHIP);
            event.getGeneration().getFeatures(GenerationStage.Decoration.LOCAL_MODIFICATIONS).add(() -> ModConfiguredFeatures.TUNEL_CAVE);
            event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_ORES).add(() -> ModConfiguredFeatures.THALLASIUM_ORE);
            event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_ORES).add(() -> ModConfiguredFeatures.ENDER_ORE);
            event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_ORES).add(() -> ModConfiguredFeatures.FLAVOLITE_LAYER);
            if (ModBiomes.getBiome(event.getName()).hasCaves()) {
                event.getGeneration().getFeatures(GenerationStage.Decoration.RAW_GENERATION).add(() -> ModConfiguredFeatures.ROUND_CAVE);
            }
            if (!ModBiomes.getBiome(event.getName()).getNBTStructures().isEmpty()) {
                event.getGeneration().getFeatures(GenerationStage.Decoration.SURFACE_STRUCTURES).add(() -> ModConfiguredFeatures.NBT_STRUCTURES);
            }
            if (event.getName().equals((Object)ModBiomes.SHADOW_FOREST.getID())) {
                MobSpawnInfo.Spawners phantom = new MobSpawnInfo.Spawners(EntityType.func_220327_a((String)"deadlyendphantoms:specter").orElse(EntityType.field_203097_aH), 10, 1, 2);
                event.getSpawns().getSpawner(EntityClassification.MONSTER).add(phantom);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void removeChorusFromVanillaBiomes(BiomeLoadingEvent event) {
        if (GeneratorOptions.removeChorusFromVanillaBiomes() && event.getCategory() == Biome.Category.THEEND) {
            if (event.getName() == null || !event.getName().func_110624_b().equals("minecraft")) {
                return;
            }
            String path = event.getName().func_110623_a();
            if (path.equals("end_highlands") || path.equals("end_midlands") || path.equals("small_end_islands")) {
                event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION).removeIf(supplier -> {
                    ConfiguredFeature feature = (ConfiguredFeature)supplier.get();
                    while (feature.func_242766_b() instanceof DecoratedFeature) {
                        feature = (ConfiguredFeature)((DecoratedFeatureConfig)feature.func_242767_c()).field_214689_a.get();
                    }
                    return feature.field_222737_a instanceof ChorusPlantFeature;
                });
            }
        }
    }
}

