/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.sdf.SDF;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFUnion;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFLine;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFPrimitive;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;

public class SplineHelper {
    public static List<Vector3f> makeSpline(float x1, float y1, float z1, float x2, float y2, float z2, int points) {
        ArrayList spline = Lists.newArrayList();
        spline.add(new Vector3f(x1, y1, z1));
        int count = points - 1;
        for (int i = 1; i < count; ++i) {
            float delta = (float)i / (float)count;
            float x = MathHelper.func_219799_g((float)delta, (float)x1, (float)x2);
            float y = MathHelper.func_219799_g((float)delta, (float)y1, (float)y2);
            float z = MathHelper.func_219799_g((float)delta, (float)z1, (float)z2);
            spline.add(new Vector3f(x, y, z));
        }
        spline.add(new Vector3f(x2, y2, z2));
        return spline;
    }

    public static void offsetParts(List<Vector3f> spline, Random random, float dx, float dy, float dz) {
        int count = spline.size();
        for (int i = 1; i < count; ++i) {
            Vector3f pos = spline.get(i);
            float x = pos.func_195899_a() + (float)random.nextGaussian() * dx;
            float y = pos.func_195900_b() + (float)random.nextGaussian() * dy;
            float z = pos.func_195902_c() + (float)random.nextGaussian() * dz;
            pos.func_195905_a(x, y, z);
        }
    }

    public static void powerOffset(List<Vector3f> spline, float distance, float power) {
        int count = spline.size();
        float max = count + 1;
        for (int i = 1; i < count; ++i) {
            Vector3f pos = spline.get(i);
            float x = (float)i / max;
            float y = pos.func_195900_b() + (float)Math.pow(x, power) * distance;
            pos.func_195905_a(pos.func_195899_a(), y, pos.func_195902_c());
        }
    }

    public static SDF buildSDF(List<Vector3f> spline, float radius1, float radius2, Function<BlockPos, BlockState> placerFunction) {
        int count = spline.size();
        float max = count - 2;
        SDFPrimitive result = null;
        Vector3f start = spline.get(0);
        for (int i = 1; i < count; ++i) {
            Vector3f pos = spline.get(i);
            float delta = (float)(i - 1) / max;
            SDFPrimitive line = new SDFLine().setRadius(MathHelper.func_219799_g((float)delta, (float)radius1, (float)radius2)).setStart(start.func_195899_a(), start.func_195900_b(), start.func_195902_c()).setEnd(pos.func_195899_a(), pos.func_195900_b(), pos.func_195902_c()).setBlock(placerFunction);
            result = result == null ? line : new SDFUnion().setSourceA(result).setSourceB(line);
            start = pos;
        }
        return result;
    }

    public static boolean fillSpline(List<Vector3f> spline, IWorld world, BlockState state, BlockPos pos, Function<BlockState, Boolean> replace) {
        Vector3f startPos = spline.get(0);
        for (int i = 1; i < spline.size(); ++i) {
            Vector3f endPos = spline.get(i);
            if (!SplineHelper.fillLine(startPos, endPos, world, state, pos, replace)) {
                return false;
            }
            startPos = endPos;
        }
        return true;
    }

    public static void fillSplineForce(List<Vector3f> spline, IWorld world, BlockState state, BlockPos pos, Function<BlockState, Boolean> replace) {
        Vector3f startPos = spline.get(0);
        for (int i = 1; i < spline.size(); ++i) {
            Vector3f endPos = spline.get(i);
            SplineHelper.fillLineForce(startPos, endPos, world, state, pos, replace);
            startPos = endPos;
        }
    }

    public static void fillLineForce(Vector3f start, Vector3f end, IWorld world, BlockState state, BlockPos pos, Function<BlockState, Boolean> replace) {
        BlockState bState;
        float dx = end.func_195899_a() - start.func_195899_a();
        float dy = end.func_195900_b() - start.func_195900_b();
        float dz = end.func_195902_c() - start.func_195902_c();
        float max = ModMathHelper.max(Math.abs(dx), Math.abs(dy), Math.abs(dz));
        int count = ModMathHelper.floor(max + 1.0f);
        dx /= max;
        dz /= max;
        float x = start.func_195899_a();
        float y = start.func_195900_b();
        float z = start.func_195902_c();
        boolean down = (double)Math.abs(dy /= max) > 0.2;
        BlockPos.Mutable bPos = new BlockPos.Mutable();
        for (int i = 0; i < count; ++i) {
            bPos.func_189532_c((double)(x + (float)pos.func_177958_n()), (double)(y + (float)pos.func_177956_o()), (double)(z + (float)pos.func_177952_p()));
            bState = world.func_180495_p((BlockPos)bPos);
            if (replace.apply(bState).booleanValue()) {
                BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)bPos, state);
                bPos.func_185336_p(bPos.func_177956_o() - 1);
                bState = world.func_180495_p((BlockPos)bPos);
                if (down && replace.apply(bState).booleanValue()) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)bPos, state);
                }
            }
            x += dx;
            y += dy;
            z += dz;
        }
        bPos.func_189532_c((double)(end.func_195899_a() + (float)pos.func_177958_n()), (double)(end.func_195900_b() + (float)pos.func_177956_o()), (double)(end.func_195902_c() + (float)pos.func_177952_p()));
        bState = world.func_180495_p((BlockPos)bPos);
        if (replace.apply(bState).booleanValue()) {
            BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)bPos, state);
            bPos.func_185336_p(bPos.func_177956_o() - 1);
            bState = world.func_180495_p((BlockPos)bPos);
            if (down && replace.apply(bState).booleanValue()) {
                BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)bPos, state);
            }
        }
    }

    private static boolean fillLine(Vector3f start, Vector3f end, IWorld world, BlockState state, BlockPos pos, Function<BlockState, Boolean> replace) {
        BlockState bState;
        float dx = end.func_195899_a() - start.func_195899_a();
        float dy = end.func_195900_b() - start.func_195900_b();
        float dz = end.func_195902_c() - start.func_195902_c();
        float max = ModMathHelper.max(Math.abs(dx), Math.abs(dy), Math.abs(dz));
        int count = ModMathHelper.floor(max + 1.0f);
        dx /= max;
        dz /= max;
        float x = start.func_195899_a();
        float y = start.func_195900_b();
        float z = start.func_195902_c();
        boolean down = (double)Math.abs(dy /= max) > 0.2;
        BlockPos.Mutable bPos = new BlockPos.Mutable();
        for (int i = 0; i < count; ++i) {
            bPos.func_189532_c((double)(x + (float)pos.func_177958_n()), (double)(y + (float)pos.func_177956_o()), (double)(z + (float)pos.func_177952_p()));
            bState = world.func_180495_p((BlockPos)bPos);
            if (bState.equals(state) || replace.apply(bState).booleanValue()) {
                BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)bPos, state);
                bPos.func_185336_p(bPos.func_177956_o() - 1);
                bState = world.func_180495_p((BlockPos)bPos);
                if (down && bState.equals(state) || replace.apply(bState).booleanValue()) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)bPos, state);
                }
            } else {
                return false;
            }
            x += dx;
            y += dy;
            z += dz;
        }
        bPos.func_189532_c((double)(end.func_195899_a() + (float)pos.func_177958_n()), (double)(end.func_195900_b() + (float)pos.func_177956_o()), (double)(end.func_195902_c() + (float)pos.func_177952_p()));
        bState = world.func_180495_p((BlockPos)bPos);
        if (bState.equals(state) || replace.apply(bState).booleanValue()) {
            BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)bPos, state);
            bPos.func_185336_p(bPos.func_177956_o() - 1);
            bState = world.func_180495_p((BlockPos)bPos);
            if (down && bState.equals(state) || replace.apply(bState).booleanValue()) {
                BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)bPos, state);
            }
            return true;
        }
        return false;
    }

    public static boolean canGenerate(List<Vector3f> spline, float scale, BlockPos start, IWorldReader world, Function<BlockState, Boolean> canReplace) {
        int count = spline.size();
        Vector3f vec = spline.get(0);
        BlockPos.Mutable mut = new BlockPos.Mutable();
        float x1 = (float)start.func_177958_n() + vec.func_195899_a() * scale;
        float y1 = (float)start.func_177956_o() + vec.func_195900_b() * scale;
        float z1 = (float)start.func_177952_p() + vec.func_195902_c() * scale;
        for (int i = 1; i < count; ++i) {
            vec = spline.get(i);
            float x2 = (float)start.func_177958_n() + vec.func_195899_a() * scale;
            float y2 = (float)start.func_177956_o() + vec.func_195900_b() * scale;
            float z2 = (float)start.func_177952_p() + vec.func_195902_c() * scale;
            for (float py = y1; py < y2; py += 3.0f) {
                if (py - (float)start.func_177956_o() < 10.0f) continue;
                float lerp = (py - y1) / (y2 - y1);
                float x = MathHelper.func_219799_g((float)lerp, (float)x1, (float)x2);
                float z = MathHelper.func_219799_g((float)lerp, (float)z1, (float)z2);
                mut.func_189532_c((double)x, (double)py, (double)z);
                if (canReplace.apply(world.func_180495_p((BlockPos)mut)).booleanValue()) continue;
                return false;
            }
            x1 = x2;
            y1 = y2;
            z1 = z2;
        }
        return true;
    }

    public static boolean canGenerate(List<Vector3f> spline, BlockPos start, IWorldReader world, Function<BlockState, Boolean> canReplace) {
        int count = spline.size();
        Vector3f vec = spline.get(0);
        BlockPos.Mutable mut = new BlockPos.Mutable();
        float x1 = (float)start.func_177958_n() + vec.func_195899_a();
        float y1 = (float)start.func_177956_o() + vec.func_195900_b();
        float z1 = (float)start.func_177952_p() + vec.func_195902_c();
        for (int i = 1; i < count; ++i) {
            vec = spline.get(i);
            float x2 = (float)start.func_177958_n() + vec.func_195899_a();
            float y2 = (float)start.func_177956_o() + vec.func_195900_b();
            float z2 = (float)start.func_177952_p() + vec.func_195902_c();
            for (float py = y1; py < y2; py += 3.0f) {
                if (py - (float)start.func_177956_o() < 10.0f) continue;
                float lerp = (py - y1) / (y2 - y1);
                float x = MathHelper.func_219799_g((float)lerp, (float)x1, (float)x2);
                float z = MathHelper.func_219799_g((float)lerp, (float)z1, (float)z2);
                mut.func_189532_c((double)x, (double)py, (double)z);
                if (canReplace.apply(world.func_180495_p((BlockPos)mut)).booleanValue()) continue;
                return false;
            }
            x1 = x2;
            y1 = y2;
            z1 = z2;
        }
        return true;
    }

    public static Vector3f getPos(List<Vector3f> spline, float index) {
        int i = (int)index;
        float delta = index - (float)i;
        Vector3f p1 = spline.get(i);
        Vector3f p2 = spline.get(i + 1);
        float x = MathHelper.func_219799_g((float)delta, (float)p1.func_195899_a(), (float)p2.func_195899_a());
        float y = MathHelper.func_219799_g((float)delta, (float)p1.func_195900_b(), (float)p2.func_195900_b());
        float z = MathHelper.func_219799_g((float)delta, (float)p1.func_195902_c(), (float)p2.func_195902_c());
        return new Vector3f(x, y, z);
    }

    public static List<Vector3f> copySpline(List<Vector3f> spline) {
        ArrayList<Vector3f> result = new ArrayList<Vector3f>(spline.size());
        for (Vector3f v : spline) {
            result.add(new Vector3f(v.func_195899_a(), v.func_195900_b(), v.func_195902_c()));
        }
        return result;
    }

    public static void rotateSpline(List<Vector3f> spline, float angle) {
        for (Vector3f v : spline) {
            float sin = (float)Math.sin(angle);
            float cos = (float)Math.cos(angle);
            float x = v.func_195899_a() * cos + v.func_195902_c() * sin;
            float z = v.func_195899_a() * sin + v.func_195902_c() * cos;
            v.func_195905_a(x, v.func_195900_b(), z);
        }
    }

    public static void scale(List<Vector3f> spline, float scale) {
        for (Vector3f v : spline) {
            v.func_195905_a(v.func_195899_a() * scale, v.func_195900_b() * scale, v.func_195902_c() * scale);
        }
    }

    public static void scale(List<Vector3f> spline, float x, float y, float z) {
        for (Vector3f v : spline) {
            v.func_195905_a(v.func_195899_a() * x, v.func_195900_b() * y, v.func_195902_c() * z);
        }
    }

    public static void offset(List<Vector3f> spline, Vector3f offset) {
        for (Vector3f v : spline) {
            v.func_195905_a(offset.func_195899_a() + v.func_195899_a(), offset.func_195900_b() + v.func_195900_b(), offset.func_195902_c() + v.func_195902_c());
        }
    }
}

