/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.biome;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.List;
import java.util.Random;
import mod.beethoven92.betterendforge.common.init.ModBiomes;
import mod.beethoven92.betterendforge.common.util.JsonFactory;
import mod.beethoven92.betterendforge.common.util.StructureHelper;
import mod.beethoven92.betterendforge.common.world.biome.BiomeTemplate;
import mod.beethoven92.betterendforge.common.world.feature.BiomeNBTStructures;
import mod.beethoven92.betterendforge.common.world.feature.NBTFeature;
import mod.beethoven92.betterendforge.config.Configs;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;

public class BetterEndBiome {
    protected List<BetterEndBiome> subbiomes = Lists.newArrayList();
    private final Biome biome;
    private final ResourceLocation id;
    protected BetterEndBiome edge;
    protected int edgeSize;
    protected BetterEndBiome biomeParent;
    protected float maxSubBiomeChance = 1.0f;
    protected final float genChanceUnmutable;
    private float genChance = 1.0f;
    private final float fogDensity;
    private final boolean hasCaves;
    private Biome actualBiome;
    private List<BiomeNBTStructures.StructureInfo> nbtStructures = Lists.newArrayList();

    public BetterEndBiome(BiomeTemplate template) {
        this.biome = template.build();
        this.id = template.getID();
        this.fogDensity = Configs.BIOME_CONFIG.getFloat(this.id, "fog_density", template.getFogDensity());
        this.genChanceUnmutable = Configs.BIOME_CONFIG.getFloat(this.id, "generation_chance", template.getGenChance());
        this.hasCaves = Configs.BIOME_CONFIG.getBoolean(this.id, "has_caves", template.hasCaves());
        this.readNBTStructureList();
    }

    public BetterEndBiome(ResourceLocation id, Biome biome, float fogDensity, float genChance, boolean hasCaves) {
        this.biome = biome;
        this.id = id;
        this.fogDensity = Configs.BIOME_CONFIG.getFloat(id, "fog_density", fogDensity);
        this.genChanceUnmutable = Configs.BIOME_CONFIG.getFloat(id, "generation_chance", genChance);
        this.hasCaves = Configs.BIOME_CONFIG.getBoolean(id, "has_caves", hasCaves);
        this.readNBTStructureList();
    }

    public BetterEndBiome getEdge() {
        return this.edge == null ? this : this.edge;
    }

    public void setEdge(BetterEndBiome edge) {
        this.edge = edge;
        edge.biomeParent = this;
    }

    public int getEdgeSize() {
        return this.edgeSize;
    }

    public void setEdgeSize(int size) {
        this.edgeSize = size;
    }

    public void addSubBiome(BetterEndBiome biome) {
        this.maxSubBiomeChance += biome.mutateGenChance(this.maxSubBiomeChance);
        biome.biomeParent = this;
        this.subbiomes.add(biome);
    }

    public BetterEndBiome getSubBiome(Random random) {
        float chance = random.nextFloat() * this.maxSubBiomeChance;
        for (BetterEndBiome biome : this.subbiomes) {
            if (!biome.canGenerate(chance)) continue;
            return biome;
        }
        return this;
    }

    public BetterEndBiome getParentBiome() {
        return this.biomeParent;
    }

    public boolean hasEdge() {
        return this.edge != null;
    }

    public boolean hasParentBiome() {
        return this.biomeParent != null;
    }

    public boolean isSame(BetterEndBiome biome) {
        return biome == this || biome.hasParentBiome() && biome.getParentBiome() == this;
    }

    public boolean canGenerate(float chance) {
        return chance <= this.genChance;
    }

    public float mutateGenChance(float chance) {
        this.genChance = this.genChanceUnmutable;
        this.genChance += chance;
        return this.genChance;
    }

    public boolean containsSubBiome(ModBiomes biome) {
        return this.subbiomes.contains(biome);
    }

    public Biome getBiome() {
        return this.biome;
    }

    public ResourceLocation getID() {
        return this.id;
    }

    public float getFogDensity() {
        return this.fogDensity;
    }

    public float getGenChance() {
        return this.genChance;
    }

    public void setActualBiome(Biome biome) {
        this.actualBiome = biome;
    }

    public Biome getActualBiome() {
        return this.actualBiome;
    }

    public void updateActualBiomes(Registry<Biome> biomeRegistry) {
        this.subbiomes.forEach(sub -> {
            if (sub != this) {
                sub.updateActualBiomes(biomeRegistry);
            }
        });
        if (this.edge != null && this.edge != this) {
            this.edge.updateActualBiomes(biomeRegistry);
        }
        this.actualBiome = (Biome)biomeRegistry.func_82594_a(this.id);
    }

    public boolean hasCaves() {
        return this.hasCaves;
    }

    protected void readNBTStructureList() {
        JsonObject obj;
        JsonArray entries;
        this.nbtStructures.clear();
        String ns = this.id.func_110624_b();
        String nm = this.id.func_110623_a();
        String path = "/data/" + ns + "/structures/biome/" + nm + "/";
        InputStream inputstream = StructureHelper.class.getResourceAsStream(path + "structures.json");
        if (inputstream != null && (entries = (obj = JsonFactory.getJsonObject(inputstream)).getAsJsonArray("structures")) != null) {
            entries.forEach(entry -> {
                JsonObject e = entry.getAsJsonObject();
                String structurePath = path + e.get("nbt").getAsString() + ".nbt";
                String replacePath = nm + "\\" + e.get("nbt").getAsString();
                NBTFeature.TerrainMerge terrainMerge = NBTFeature.TerrainMerge.getFromString(e.get("terrainMerge").getAsString());
                int offsetY = e.get("offsetY").getAsInt();
                this.nbtStructures.add(new BiomeNBTStructures.StructureInfo(structurePath, replacePath, offsetY, terrainMerge));
            });
        }
    }

    public List<BiomeNBTStructures.StructureInfo> getNBTStructures() {
        return this.nbtStructures;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        BetterEndBiome biome = (BetterEndBiome)obj;
        return biome == null ? false : biome.id.equals((Object)this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

