/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import java.util.Random;
import mod.beethoven92.betterendforge.common.block.BlockProperties;
import mod.beethoven92.betterendforge.common.block.EndLotusLeafBlock;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.world.feature.ScatterFeature;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.Heightmap;

public class EndLotusLeafFeature
extends ScatterFeature {
    public EndLotusLeafFeature(int radius) {
        super(radius);
    }

    private boolean canGenerate(ISeedReader world, BlockPos blockPos) {
        BlockPos.Mutable p = new BlockPos.Mutable();
        p.func_185336_p(blockPos.func_177956_o());
        int count = 0;
        for (int x = -1; x < 2; ++x) {
            p.func_223471_o(blockPos.func_177958_n() + x);
            for (int z = -1; z < 2; ++z) {
                p.func_223472_q(blockPos.func_177952_p() + z);
                if (!world.func_175623_d((BlockPos)p) || !world.func_180495_p(p.func_177977_b()).func_203425_a(Blocks.field_150355_j)) continue;
                ++count;
            }
        }
        return count == 9;
    }

    @Override
    public boolean canGenerate(ISeedReader world, Random random, BlockPos center, BlockPos blockPos, float radius) {
        return world.func_175623_d(blockPos) && world.func_180495_p(blockPos.func_177977_b()).func_203425_a(Blocks.field_150355_j);
    }

    @Override
    public void generate(ISeedReader world, Random random, BlockPos blockPos) {
        if (this.canGenerate(world, blockPos)) {
            this.generateLeaf(world, blockPos);
        }
    }

    private void generateLeaf(ISeedReader world, BlockPos pos) {
        BlockPos.Mutable p = new BlockPos.Mutable();
        BlockState leaf = ((Block)ModBlocks.END_LOTUS_LEAF.get()).func_176223_P();
        BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, (BlockState)leaf.func_206870_a(EndLotusLeafBlock.SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM)));
        for (Direction move : BlockHelper.HORIZONTAL_DIRECTIONS) {
            BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)p.func_189533_g((Vector3i)pos).func_189536_c(move), (BlockState)((BlockState)leaf.func_206870_a((Property)EndLotusLeafBlock.HORIZONTAL_FACING, (Comparable)move)).func_206870_a(EndLotusLeafBlock.SHAPE, (Comparable)((Object)BlockProperties.TripleShape.MIDDLE)));
        }
        for (int i = 0; i < 4; ++i) {
            Direction d1 = BlockHelper.HORIZONTAL_DIRECTIONS[i];
            Direction d2 = BlockHelper.HORIZONTAL_DIRECTIONS[i + 1 & 3];
            BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)p.func_189533_g((Vector3i)pos).func_189536_c(d1).func_189536_c(d2), (BlockState)((BlockState)leaf.func_206870_a((Property)EndLotusLeafBlock.HORIZONTAL_FACING, (Comparable)d1)).func_206870_a(EndLotusLeafBlock.SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP)));
        }
    }

    @Override
    protected int getChance() {
        return 15;
    }

    @Override
    protected BlockPos getCenterGround(ISeedReader world, BlockPos pos) {
        return world.func_205770_a(Heightmap.Type.WORLD_SURFACE, pos);
    }
}

