/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import java.util.List;
import java.util.Random;
import java.util.function.Function;
import mod.beethoven92.betterendforge.common.block.template.AttachedBlock;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.SplineHelper;
import mod.beethoven92.betterendforge.common.util.sdf.PosInfo;
import mod.beethoven92.betterendforge.common.util.sdf.SDF;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class GiganticAmaranitaFeature
extends Feature<NoFeatureConfig> {
    private static final Function<BlockState, Boolean> REPLACE = state -> {
        if (state.func_235714_a_(ModTags.END_GROUND) || state.func_185904_a().equals(Material.field_151585_k)) {
            return true;
        }
        return state.func_185904_a().func_76222_j();
    };
    private static final Function<BlockState, Boolean> IGNORE = state -> ModBlocks.DRAGON_TREE.isTreeLog((BlockState)state);
    private static final Function<PosInfo, BlockState> POST = info -> {
        if (!info.getStateUp().func_203425_a((Block)ModBlocks.AMARANITA_STEM.get()) || !info.getStateDown().func_203425_a((Block)ModBlocks.AMARANITA_STEM.get())) {
            return ((Block)ModBlocks.AMARANITA_HYPHAE.get()).func_176223_P();
        }
        return info.getState();
    };

    public GiganticAmaranitaFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        if (!world.func_180495_p(pos.func_177977_b()).func_177230_c().func_203417_a(ModTags.END_GROUND)) {
            return false;
        }
        float size = ModMathHelper.randRange(5, 10, random);
        List<Vector3f> spline = SplineHelper.makeSpline(0.0f, 0.0f, 0.0f, 0.0f, size, 0.0f, 5);
        SplineHelper.offsetParts(spline, random, 0.7f, 0.0f, 0.7f);
        if (!SplineHelper.canGenerate(spline, pos, (IWorldReader)world, REPLACE)) {
            return false;
        }
        BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, Blocks.field_150350_a.func_176223_P());
        float radius = size * 0.17f;
        SDF function = SplineHelper.buildSDF(spline, radius, 0.2f, bpos -> ((Block)ModBlocks.AMARANITA_STEM.get()).func_176223_P());
        Vector3f capPos = spline.get(spline.size() - 1);
        this.makeHead(world, pos.func_177963_a((double)(capPos.func_195899_a() + 0.5f), (double)(capPos.func_195900_b() + 1.5f), (double)(capPos.func_195902_c() + 0.5f)), MathHelper.func_76141_d((float)(size / 1.6f)));
        function.setReplaceFunction(REPLACE);
        function.addPostProcess(POST);
        function.fillRecursiveIgnore((IWorld)world, pos, IGNORE);
        for (int i = 0; i < 3; ++i) {
            List<Vector3f> copy = SplineHelper.copySpline(spline);
            SplineHelper.offsetParts(copy, random, 0.2f, 0.0f, 0.2f);
            SplineHelper.fillSplineForce(copy, (IWorld)world, ((Block)ModBlocks.AMARANITA_HYPHAE.get()).func_176223_P(), pos, REPLACE);
        }
        return true;
    }

    private void makeHead(ISeedReader world, BlockPos pos, int radius) {
        BlockPos.Mutable mut = new BlockPos.Mutable();
        if (radius < 2) {
            for (int i = -1; i < 2; ++i) {
                mut.func_189533_g((Vector3i)pos).func_189534_c(Direction.NORTH, 2).func_189534_c(Direction.EAST, i);
                if (world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_HYMENOPHORE.get());
                }
                mut.func_189533_g((Vector3i)pos).func_189534_c(Direction.SOUTH, 2).func_189534_c(Direction.EAST, i);
                if (world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_HYMENOPHORE.get());
                }
                mut.func_189533_g((Vector3i)pos).func_189534_c(Direction.EAST, 2).func_189534_c(Direction.NORTH, i);
                if (world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_HYMENOPHORE.get());
                }
                mut.func_189533_g((Vector3i)pos).func_189534_c(Direction.WEST, 2).func_189534_c(Direction.NORTH, i);
                if (!world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) continue;
                BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_HYMENOPHORE.get());
            }
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    mut.func_189533_g((Vector3i)pos).func_196234_d(x, 0, z);
                    if (!world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) continue;
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_LANTERN.get());
                    mut.func_189536_c(Direction.DOWN);
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_LANTERN.get());
                    mut.func_189536_c(Direction.DOWN);
                    if (!world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) continue;
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (BlockState)((Block)ModBlocks.AMARANITA_FUR.get()).func_176223_P().func_206870_a((Property)AttachedBlock.FACING, (Comparable)Direction.DOWN));
                }
            }
            int h = radius + 1;
            for (int y = 0; y < h; ++y) {
                mut.func_185336_p(pos.func_177956_o() + y + 1);
                for (int x = -1; x < 2; ++x) {
                    mut.func_223471_o(pos.func_177958_n() + x);
                    for (int z = -1; z < 2; ++z) {
                        mut.func_223472_q(pos.func_177952_p() + z);
                        if (!world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) continue;
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_CAP.get());
                    }
                }
            }
            mut.func_185336_p(pos.func_177956_o() + h + 1);
            for (int x = -1; x < 2; ++x) {
                mut.func_223471_o(pos.func_177958_n() + x);
                for (int z = -1; z < 2; ++z) {
                    mut.func_223472_q(pos.func_177952_p() + z);
                    if (x != 0 && z != 0 || !world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) continue;
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_CAP.get());
                }
            }
        } else if (radius < 4) {
            pos = pos.func_177982_a(-1, 0, -1);
            for (int i = -2; i < 2; ++i) {
                mut.func_189533_g((Vector3i)pos).func_189534_c(Direction.NORTH, 2).func_189534_c(Direction.WEST, i);
                if (world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_HYMENOPHORE.get());
                }
                mut.func_189533_g((Vector3i)pos).func_189534_c(Direction.SOUTH, 3).func_189534_c(Direction.WEST, i);
                if (world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_HYMENOPHORE.get());
                }
                mut.func_189533_g((Vector3i)pos).func_189534_c(Direction.EAST, 3).func_189534_c(Direction.NORTH, i);
                if (world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_HYMENOPHORE.get());
                }
                mut.func_189533_g((Vector3i)pos).func_189534_c(Direction.WEST, 2).func_189534_c(Direction.NORTH, i);
                if (!world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) continue;
                BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_HYMENOPHORE.get());
            }
            for (int x = -1; x < 3; ++x) {
                for (int z = -1; z < 3; ++z) {
                    mut.func_189533_g((Vector3i)pos).func_196234_d(x, 0, z);
                    if (!world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) continue;
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_LANTERN.get());
                    mut.func_189536_c(Direction.DOWN);
                    if (x >> 1 == 0 || z >> 1 == 0) {
                        Direction.Axis axis;
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_LANTERN.get());
                        Direction.Axis axis2 = axis = x < 0 || x > 1 ? Direction.Axis.X : Direction.Axis.Z;
                        int distance = axis == Direction.Axis.X ? (x < 0 ? -1 : 1) : (z < 0 ? -1 : 1);
                        BlockPos offseted = mut.func_241872_a(axis, distance);
                        if (world.func_180495_p(offseted).func_185904_a().func_76222_j()) {
                            Direction dir = Direction.func_211699_a((Direction.Axis)axis, (Direction.AxisDirection)(distance < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
                            BlockHelper.setWithoutUpdate((IWorldWriter)world, offseted, (BlockState)((Block)ModBlocks.AMARANITA_FUR.get()).func_176223_P().func_206870_a((Property)AttachedBlock.FACING, (Comparable)dir));
                        }
                        mut.func_189536_c(Direction.DOWN);
                    }
                    if (!world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) continue;
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (BlockState)((Block)ModBlocks.AMARANITA_FUR.get()).func_176223_P().func_206870_a((Property)AttachedBlock.FACING, (Comparable)Direction.DOWN));
                }
            }
            int h = radius - 1;
            for (int y = 0; y < h; ++y) {
                mut.func_185336_p(pos.func_177956_o() + y + 1);
                for (int x = -1; x < 3; ++x) {
                    mut.func_223471_o(pos.func_177958_n() + x);
                    for (int z = -1; z < 3; ++z) {
                        mut.func_223472_q(pos.func_177952_p() + z);
                        if (!world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) continue;
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_CAP.get());
                    }
                }
            }
            mut.func_185336_p(pos.func_177956_o() + h + 1);
            for (int x = -1; x < 3; ++x) {
                mut.func_223471_o(pos.func_177958_n() + x);
                for (int z = -1; z < 3; ++z) {
                    mut.func_223472_q(pos.func_177952_p() + z);
                    if (x >> 1 != 0 && z >> 1 != 0 || !world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) continue;
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_CAP.get());
                }
            }
        } else {
            int i;
            for (i = -2; i < 3; ++i) {
                mut.func_189533_g((Vector3i)pos).func_189534_c(Direction.NORTH, 3).func_189534_c(Direction.EAST, i);
                if (world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_HYMENOPHORE.get());
                }
                mut.func_189536_c(Direction.UP);
                if (world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_HYMENOPHORE.get());
                }
                mut.func_189536_c(Direction.NORTH);
                if (world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_HYMENOPHORE.get());
                }
                mut.func_189533_g((Vector3i)pos).func_189534_c(Direction.SOUTH, 3).func_189534_c(Direction.EAST, i);
                if (world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_HYMENOPHORE.get());
                }
                mut.func_189536_c(Direction.UP);
                if (world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_HYMENOPHORE.get());
                }
                mut.func_189536_c(Direction.SOUTH);
                if (world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_HYMENOPHORE.get());
                }
                mut.func_189533_g((Vector3i)pos).func_189534_c(Direction.EAST, 3).func_189534_c(Direction.NORTH, i);
                if (world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_HYMENOPHORE.get());
                }
                mut.func_189536_c(Direction.UP);
                if (world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_HYMENOPHORE.get());
                }
                mut.func_189536_c(Direction.EAST);
                if (world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_HYMENOPHORE.get());
                }
                mut.func_189533_g((Vector3i)pos).func_189534_c(Direction.WEST, 3).func_189534_c(Direction.NORTH, i);
                if (world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_HYMENOPHORE.get());
                }
                mut.func_189536_c(Direction.UP);
                if (world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_HYMENOPHORE.get());
                }
                mut.func_189536_c(Direction.WEST);
                if (!world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) continue;
                BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_HYMENOPHORE.get());
            }
            for (i = 0; i < 4; ++i) {
                mut.func_189533_g((Vector3i)pos).func_189536_c(Direction.UP).func_189534_c(BlockHelper.HORIZONTAL_DIRECTIONS[i], 3).func_189534_c(BlockHelper.HORIZONTAL_DIRECTIONS[i + 1 & 3], 3);
                if (!world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) continue;
                BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_HYMENOPHORE.get());
            }
            for (int x = -2; x < 3; ++x) {
                for (int z = -2; z < 3; ++z) {
                    mut.func_189533_g((Vector3i)pos).func_196234_d(x, 0, z);
                    if (!world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) continue;
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_LANTERN.get());
                    mut.func_189536_c(Direction.DOWN);
                    if (x / 2 == 0 || z / 2 == 0) {
                        Direction.Axis axis;
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_LANTERN.get());
                        Direction.Axis axis3 = axis = x < 0 || x > 1 ? Direction.Axis.X : Direction.Axis.Z;
                        int distance = axis == Direction.Axis.X ? (x < 0 ? -1 : 1) : (z < 0 ? -1 : 1);
                        BlockPos offseted = mut.func_241872_a(axis, distance);
                        if (world.func_180495_p(offseted).func_185904_a().func_76222_j()) {
                            Direction dir = Direction.func_211699_a((Direction.Axis)axis, (Direction.AxisDirection)(distance < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
                            BlockHelper.setWithoutUpdate((IWorldWriter)world, offseted, (BlockState)((Block)ModBlocks.AMARANITA_FUR.get()).func_176223_P().func_206870_a((Property)AttachedBlock.FACING, (Comparable)dir));
                        }
                        mut.func_189536_c(Direction.DOWN);
                    }
                    if (!world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) continue;
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (BlockState)((Block)ModBlocks.AMARANITA_FUR.get()).func_176223_P().func_206870_a((Property)AttachedBlock.FACING, (Comparable)Direction.DOWN));
                }
            }
            for (int y = 0; y < 3; ++y) {
                mut.func_185336_p(pos.func_177956_o() + y + 1);
                for (int x = -2; x < 3; ++x) {
                    mut.func_223471_o(pos.func_177958_n() + x);
                    for (int z = -2; z < 3; ++z) {
                        mut.func_223472_q(pos.func_177952_p() + z);
                        if (!world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) continue;
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_CAP.get());
                    }
                }
            }
            int h = radius + 1;
            for (int y = 4; y < h; ++y) {
                mut.func_185336_p(pos.func_177956_o() + y);
                for (int x = -2; x < 3; ++x) {
                    mut.func_223471_o(pos.func_177958_n() + x);
                    for (int z = -2; z < 3; ++z) {
                        mut.func_223472_q(pos.func_177952_p() + z);
                        if (y < 6) {
                            if (x / 2 != 0 && z / 2 != 0 || !world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) continue;
                            BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_CAP.get());
                            continue;
                        }
                        if (x != 0 && z != 0 || Math.abs(x) >= 2 || Math.abs(z) >= 2 || !world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) continue;
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (Block)ModBlocks.AMARANITA_CAP.get());
                    }
                }
            }
        }
    }
}

