/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import java.util.List;
import java.util.Random;
import java.util.function.Function;
import mod.beethoven92.betterendforge.common.block.MossyGlowshroomCapBlock;
import mod.beethoven92.betterendforge.common.block.template.FurBlock;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.SplineHelper;
import mod.beethoven92.betterendforge.common.util.sdf.SDF;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFBinary;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFCoordModify;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFFlatWave;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFScale;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFScale3D;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFSmoothUnion;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFSubtraction;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFTranslate;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFUnary;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFUnion;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFCappedCone;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFPrimitive;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFSphere;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class MossyGlowshroomFeature
extends Feature<NoFeatureConfig> {
    private static final Function<BlockState, Boolean> REPLACE;
    private static final Vector3f CENTER;
    private static final SDFBinary FUNCTION;
    private static final SDFTranslate HEAD_POS;
    private static final SDFFlatWave ROOTS_ROT;
    private static final SDFPrimitive CONE1;
    private static final SDFPrimitive CONE2;
    private static final SDFPrimitive CONE_GLOW;
    private static final SDFPrimitive ROOTS;

    public MossyGlowshroomFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos blockPos, NoFeatureConfig config) {
        BlockState down = world.func_180495_p(blockPos.func_177977_b());
        if (!down.func_203425_a((Block)ModBlocks.END_MYCELIUM.get()) && !down.func_203425_a((Block)ModBlocks.END_MOSS.get())) {
            return false;
        }
        CONE1.setBlock((Block)ModBlocks.MOSSY_GLOWSHROOM_CAP.get());
        CONE2.setBlock((Block)ModBlocks.MOSSY_GLOWSHROOM_CAP.get());
        CONE_GLOW.setBlock((Block)ModBlocks.MOSSY_GLOWSHROOM_HYMENOPHORE.get());
        ROOTS.setBlock((Block)ModBlocks.MOSSY_GLOWSHROOM.bark.get());
        float height = ModMathHelper.randRange(10.0f, 25.0f, random);
        int count = MathHelper.func_76141_d((float)(height / 4.0f));
        List<Vector3f> spline = SplineHelper.makeSpline(0.0f, 0.0f, 0.0f, 0.0f, height, 0.0f, count);
        SplineHelper.offsetParts(spline, random, 1.0f, 0.0f, 1.0f);
        SDF sdf = SplineHelper.buildSDF(spline, 2.1f, 1.5f, pos -> ((Block)ModBlocks.MOSSY_GLOWSHROOM.log.get()).func_176223_P());
        Vector3f pos2 = spline.get(spline.size() - 1);
        float scale = ModMathHelper.randRange(0.75f, 1.1f, random);
        if (!SplineHelper.canGenerate(spline, scale, blockPos, (IWorldReader)world, REPLACE)) {
            return false;
        }
        world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 19);
        CENTER.func_195905_a((float)blockPos.func_177958_n(), 0.0f, (float)blockPos.func_177952_p());
        HEAD_POS.setTranslate(pos2.func_195899_a(), pos2.func_195900_b(), pos2.func_195902_c());
        ROOTS_ROT.setAngle(random.nextFloat() * ((float)Math.PI * 2));
        FUNCTION.setSourceA(sdf);
        new SDFScale().setScale(scale).setSource(FUNCTION).setReplaceFunction(REPLACE).addPostProcess(info -> {
            if (ModBlocks.MOSSY_GLOWSHROOM.isTreeLog(info.getState())) {
                if (random.nextBoolean() && info.getStateUp().func_177230_c() == ModBlocks.MOSSY_GLOWSHROOM_CAP.get()) {
                    info.setState((BlockState)((Block)ModBlocks.MOSSY_GLOWSHROOM_CAP.get()).func_176223_P().func_206870_a((Property)MossyGlowshroomCapBlock.TRANSITION, (Comparable)Boolean.valueOf(true)));
                    return info.getState();
                }
                if (!ModBlocks.MOSSY_GLOWSHROOM.isTreeLog(info.getStateUp()) || !ModBlocks.MOSSY_GLOWSHROOM.isTreeLog(info.getStateDown())) {
                    info.setState(((Block)ModBlocks.MOSSY_GLOWSHROOM.bark.get()).func_176223_P());
                    return info.getState();
                }
            } else {
                if (info.getState().func_177230_c() == ModBlocks.MOSSY_GLOWSHROOM_CAP.get()) {
                    if (ModBlocks.MOSSY_GLOWSHROOM.isTreeLog(info.getStateDown().func_177230_c())) {
                        info.setState((BlockState)((Block)ModBlocks.MOSSY_GLOWSHROOM_CAP.get()).func_176223_P().func_206870_a((Property)MossyGlowshroomCapBlock.TRANSITION, (Comparable)Boolean.valueOf(true)));
                        return info.getState();
                    }
                    info.setState(((Block)ModBlocks.MOSSY_GLOWSHROOM_CAP.get()).func_176223_P());
                    return info.getState();
                }
                if (info.getState().func_177230_c() == ModBlocks.MOSSY_GLOWSHROOM_HYMENOPHORE.get()) {
                    for (Direction dir : BlockHelper.HORIZONTAL_DIRECTIONS) {
                        if (info.getState(dir) != Blocks.field_150350_a.func_176223_P()) continue;
                        info.setBlockPos(info.getPos().func_177972_a(dir), (BlockState)((Block)ModBlocks.MOSSY_GLOWSHROOM_FUR.get()).func_176223_P().func_206870_a((Property)FurBlock.FACING, (Comparable)dir));
                    }
                    if (info.getStateDown().func_177230_c() != ModBlocks.MOSSY_GLOWSHROOM_HYMENOPHORE.get()) {
                        info.setBlockPos(info.getPos().func_177977_b(), (BlockState)((Block)ModBlocks.MOSSY_GLOWSHROOM_FUR.get()).func_176223_P().func_206870_a((Property)FurBlock.FACING, (Comparable)Direction.DOWN));
                    }
                }
            }
            return info.getState();
        }).fillRecursive((IWorld)world, blockPos);
        return true;
    }

    static {
        CENTER = new Vector3f();
        SDFCappedCone cone1 = new SDFCappedCone().setHeight(2.5f).setRadius1(1.5f).setRadius2(2.5f);
        SDFCappedCone cone2 = new SDFCappedCone().setHeight(3.0f).setRadius1(2.5f).setRadius2(13.0f);
        SDFUnary posedCone2 = new SDFTranslate().setTranslate(0.0f, 5.0f, 0.0f).setSource(cone2);
        SDFUnary posedCone3 = new SDFTranslate().setTranslate(0.0f, 12.0f, 0.0f).setSource(new SDFScale().setScale(2.0f).setSource(cone2));
        SDFBinary upCone = new SDFSubtraction().setSourceA(posedCone2).setSourceB(posedCone3);
        SDFUnary wave = new SDFFlatWave().setRaysCount(12).setIntensity(1.3f).setSource(upCone);
        SDF cones = new SDFSmoothUnion().setRadius(3.0f).setSourceA(cone1).setSourceB(wave);
        CONE1 = cone1;
        CONE2 = cone2;
        SDFUnary innerCone = new SDFTranslate().setTranslate(0.0f, 1.25f, 0.0f).setSource(upCone);
        innerCone = new SDFScale3D().setScale(1.2f, 1.0f, 1.2f).setSource(innerCone);
        cones = new SDFUnion().setSourceA(cones).setSourceB(innerCone);
        SDF glowCone = new SDFCappedCone().setHeight(3.0f).setRadius1(2.0f).setRadius2(12.5f);
        CONE_GLOW = glowCone;
        glowCone = new SDFTranslate().setTranslate(0.0f, 4.25f, 0.0f).setSource(glowCone);
        glowCone = new SDFSubtraction().setSourceA(glowCone).setSourceB(posedCone3);
        cones = new SDFUnion().setSourceA(cones).setSourceB(glowCone);
        OpenSimplexNoise noise = new OpenSimplexNoise(1234L);
        cones = new SDFCoordModify().setFunction(pos -> {
            float dist = ModMathHelper.length(pos.func_195899_a(), pos.func_195902_c());
            float y = pos.func_195900_b() + (float)noise.eval((double)pos.func_195899_a() * 0.1 + (double)CENTER.func_195899_a(), (double)pos.func_195902_c() * 0.1 + (double)CENTER.func_195902_c()) * dist * 0.3f - dist * 0.15f;
            pos.func_195905_a(pos.func_195899_a(), y, pos.func_195902_c());
        }).setSource(cones);
        HEAD_POS = (SDFTranslate)new SDFTranslate().setSource(new SDFTranslate().setTranslate(0.0f, 2.5f, 0.0f).setSource(cones));
        SDF roots = new SDFSphere().setRadius(4.0f);
        ROOTS = roots;
        roots = new SDFScale3D().setScale(1.0f, 0.7f, 1.0f).setSource(roots);
        ROOTS_ROT = (SDFFlatWave)new SDFFlatWave().setRaysCount(5).setIntensity(1.5f).setSource(roots);
        FUNCTION = new SDFSmoothUnion().setRadius(4.0f).setSourceB(new SDFUnion().setSourceA(HEAD_POS).setSourceB(ROOTS_ROT));
        REPLACE = state -> {
            if (state.func_235714_a_(ModTags.END_GROUND)) {
                return true;
            }
            if (state.func_185904_a().equals(Material.field_151585_k)) {
                return true;
            }
            return state.func_185904_a().func_76222_j();
        };
    }
}

