/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import java.util.Random;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.FeatureHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.sdf.SDF;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFCoordModify;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFDisplacement;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFRotation;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFUnion;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFTorus;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import net.minecraft.block.Block;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class ThinArchFeature
extends Feature<NoFeatureConfig> {
    private Block block;

    public ThinArchFeature(Block block) {
        super(NoFeatureConfig.field_236558_a_);
        this.block = block;
    }

    public static AxisAlignedBB ofSize(Vector3d vec3, double d, double e, double f) {
        return new AxisAlignedBB(vec3.field_72450_a - d / 2.0, vec3.field_72448_b - e / 2.0, vec3.field_72449_c - f / 2.0, vec3.field_72450_a + d / 2.0, vec3.field_72448_b + e / 2.0, vec3.field_72449_c + f / 2.0);
    }

    public static Vector3d atCenterOf(Vector3i vec3i) {
        return new Vector3d((double)vec3i.func_177958_n() + 0.5, (double)vec3i.func_177956_o() + 0.5, (double)vec3i.func_177952_p() + 0.5);
    }

    public boolean generate(ISeedReader level, ChunkGenerator generator, Random random, BlockPos origin, NoFeatureConfig config) {
        ISeedReader world = level;
        BlockPos pos = FeatureHelper.getPosOnSurface(world, new BlockPos(origin.func_177958_n() & 0xFFFFFFF0 | 7, 0, origin.func_177952_p() & 0xFFFFFFF0 | 7));
        if (!world.func_180495_p(pos.func_177979_c(5)).func_235714_a_(ModTags.GEN_TERRAIN)) {
            return false;
        }
        SDF sdf = null;
        float bigRadius = ModMathHelper.randRange(15.0f, 20.0f, random);
        float variation = bigRadius * 0.3f;
        int count = ModMathHelper.randRange(2, 4, random);
        for (int i = 0; i < count; ++i) {
            float smallRadius = ModMathHelper.randRange(0.6f, 1.3f, random);
            SDF arch = new SDFTorus().setBigRadius(bigRadius - random.nextFloat() * variation).setSmallRadius(smallRadius).setBlock(this.block);
            float angle = ((float)i - (float)count * 0.5f) * 0.3f + random.nextFloat() * 0.05f + 1.5707964f;
            arch = new SDFRotation().setRotation(Vector3f.field_229179_b_, angle).setSource(arch);
            sdf = sdf == null ? arch : new SDFUnion().setSourceA(sdf).setSourceB(arch);
        }
        sdf = new SDFRotation().setRotation(ModMathHelper.randomHorizontal(random), random.nextFloat() * ((float)Math.PI * 2)).setSource(sdf);
        OpenSimplexNoise noise = new OpenSimplexNoise(random.nextLong());
        sdf = new SDFCoordModify().setFunction(vec -> {
            float dx = (float)noise.eval((double)vec.func_195900_b() * 0.02, (double)vec.func_195902_c() * 0.02);
            float dy = (float)noise.eval((double)vec.func_195899_a() * 0.02, (double)vec.func_195902_c() * 0.02);
            float dz = (float)noise.eval((double)vec.func_195899_a() * 0.02, (double)vec.func_195900_b() * 0.02);
            vec.func_195905_a(vec.func_195899_a() + dx * 10.0f, vec.func_195900_b() + dy * 10.0f, vec.func_195902_c() + dz * 10.0f);
        }).setSource(sdf);
        sdf = new SDFDisplacement().setFunction(vec -> {
            float offset = vec.func_195900_b() / bigRadius - 0.5f;
            return Float.valueOf(MathHelper.func_76131_a((float)(offset * 3.0f), (float)-10.0f, (float)0.0f));
        }).setSource(sdf);
        float side = (bigRadius + 2.5f) * 2.0f;
        if (side > 47.0f) {
            side = 47.0f;
        }
        sdf.fillArea((IWorld)world, pos, ThinArchFeature.ofSize(ThinArchFeature.atCenterOf((Vector3i)pos), side, side, side));
        return true;
    }
}

