/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import java.util.Random;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public abstract class WallScatterFeature
extends Feature<NoFeatureConfig> {
    private static final Direction[] DIR = BlockHelper.makeHorizontal();
    private final int radius;

    public WallScatterFeature(int radius) {
        super(NoFeatureConfig.field_236558_a_);
        this.radius = radius;
    }

    public abstract boolean canGenerate(ISeedReader var1, Random var2, BlockPos var3, Direction var4);

    public abstract void generate(ISeedReader var1, Random var2, BlockPos var3, Direction var4);

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos center, NoFeatureConfig config) {
        int maxY = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, center.func_177958_n(), center.func_177952_p());
        int minY = BlockHelper.upRay((IWorldReader)world, new BlockPos(center.func_177958_n(), 0, center.func_177952_p()), maxY);
        if (maxY < 10 || maxY < minY) {
            return false;
        }
        int py = ModMathHelper.randRange(minY, maxY, random);
        BlockPos.Mutable mut = new BlockPos.Mutable();
        for (int x = -this.radius; x <= this.radius; ++x) {
            mut.func_223471_o(center.func_177958_n() + x);
            for (int y = -this.radius; y <= this.radius; ++y) {
                mut.func_185336_p(py + y);
                block2: for (int z = -this.radius; z <= this.radius; ++z) {
                    mut.func_223472_q(center.func_177952_p() + z);
                    if (random.nextInt(4) != 0 || !world.func_175623_d((BlockPos)mut)) continue;
                    this.shuffle(random);
                    for (Direction dir : DIR) {
                        if (!this.canGenerate(world, random, (BlockPos)mut, dir)) continue;
                        this.generate(world, random, (BlockPos)mut, dir);
                        continue block2;
                    }
                }
            }
        }
        return true;
    }

    private void shuffle(Random random) {
        for (int i = 0; i < 4; ++i) {
            int j = random.nextInt(4);
            Direction d = DIR[i];
            WallScatterFeature.DIR[i] = DIR[j];
            WallScatterFeature.DIR[j] = d;
        }
    }
}

