/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature.caves;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import mod.beethoven92.betterendforge.common.init.ModBiomes;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.interfaces.IBiomeArray;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.world.biome.BetterEndBiome;
import mod.beethoven92.betterendforge.common.world.biome.BetterEndCaveBiome;
import mod.beethoven92.betterendforge.common.world.generator.GeneratorOptions;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public abstract class EndCaveFeature
extends Feature<NoFeatureConfig> {
    protected static final BlockState CAVE_AIR = Blocks.field_201941_jj.func_176223_P();
    protected static final BlockState END_STONE = Blocks.field_150377_bs.func_176223_P();
    protected static final BlockState WATER = Blocks.field_150355_j.func_176223_P();
    private static final Vector3i[] SPHERE;

    public EndCaveFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (!(GeneratorOptions.useNewGenerator() && GeneratorOptions.noRingVoid() || pos.func_177958_n() * pos.func_177958_n() + pos.func_177952_p() * pos.func_177952_p() > 22500)) {
            return false;
        }
        if (this.biomeMissingCaves(world, pos)) {
            return false;
        }
        int radius = ModMathHelper.randRange(10, 30, rand);
        BlockPos center = this.findPos(world, pos, radius, rand);
        if (center == null) {
            return false;
        }
        BetterEndCaveBiome biome = ModBiomes.getCaveBiome(rand);
        Set<BlockPos> caveBlocks = this.generateCaveBlocks(world, center, radius, rand);
        if (!caveBlocks.isEmpty()) {
            if (biome != null) {
                this.setBiomes(world, biome, caveBlocks);
                HashSet floorPositions = Sets.newHashSet();
                HashSet ceilPositions = Sets.newHashSet();
                BlockPos.Mutable mut = new BlockPos.Mutable();
                caveBlocks.forEach(bpos -> {
                    mut.func_189533_g((Vector3i)bpos);
                    if (world.func_180495_p((BlockPos)mut).func_185904_a().func_76222_j()) {
                        mut.func_185336_p(bpos.func_177956_o() - 1);
                        if (world.func_180495_p((BlockPos)mut).func_235714_a_(ModTags.GEN_TERRAIN)) {
                            floorPositions.add(mut.func_185334_h());
                        }
                        mut.func_185336_p(bpos.func_177956_o() + 1);
                        if (world.func_180495_p((BlockPos)mut).func_235714_a_(ModTags.GEN_TERRAIN)) {
                            ceilPositions.add(mut.func_185334_h());
                        }
                    }
                });
                BlockState surfaceBlock = biome.getBiome().func_242440_e().func_242502_e().func_204108_a();
                this.placeFloor(world, biome, floorPositions, rand, surfaceBlock);
                this.placeCeil(world, biome, ceilPositions, rand);
                this.placeWalls(world, biome, caveBlocks, rand);
            }
            this.fixBlocks(world, caveBlocks);
        }
        return true;
    }

    protected abstract Set<BlockPos> generateCaveBlocks(ISeedReader var1, BlockPos var2, int var3, Random var4);

    protected void placeFloor(ISeedReader world, BetterEndCaveBiome biome, Set<BlockPos> floorPositions, Random random, BlockState surfaceBlock) {
        float density = biome.getFloorDensity();
        floorPositions.forEach(pos -> {
            Feature<?> feature;
            BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, surfaceBlock);
            if (density > 0.0f && random.nextFloat() <= density && (feature = biome.getFloorFeature(random)) != null) {
                feature.func_241855_a(world, null, random, pos.func_177984_a(), null);
            }
        });
    }

    protected void placeCeil(ISeedReader world, BetterEndCaveBiome biome, Set<BlockPos> ceilPositions, Random random) {
        float density = biome.getCeilDensity();
        ceilPositions.forEach(pos -> {
            Feature<?> feature;
            BlockState ceilBlock = biome.getCeil((BlockPos)pos);
            if (ceilBlock != null) {
                BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, ceilBlock);
            }
            if (density > 0.0f && random.nextFloat() <= density && (feature = biome.getCeilFeature(random)) != null) {
                feature.func_241855_a(world, null, random, pos.func_177977_b(), null);
            }
        });
    }

    protected void placeWalls(ISeedReader world, BetterEndCaveBiome biome, Set<BlockPos> positions, Random random) {
        HashSet placed = Sets.newHashSet();
        positions.forEach(pos -> {
            BlockState wallBlock;
            if (random.nextInt(4) == 0 && this.hasOpenSide((BlockPos)pos, positions) && (wallBlock = biome.getWall((BlockPos)pos)) != null) {
                for (Vector3i offset : SPHERE) {
                    BlockPos wallPos = pos.func_177971_a(offset);
                    if (positions.contains(wallPos) || placed.contains(wallPos) || !world.func_180495_p(wallPos).func_235714_a_(ModTags.GEN_TERRAIN)) continue;
                    wallBlock = biome.getWall(wallPos);
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, wallPos, wallBlock);
                    placed.add(wallPos);
                }
            }
        });
    }

    private boolean hasOpenSide(BlockPos pos, Set<BlockPos> positions) {
        for (Direction dir : BlockHelper.DIRECTIONS) {
            if (positions.contains(pos.func_177972_a(dir))) continue;
            return true;
        }
        return false;
    }

    protected void setBiomes(ISeedReader world, BetterEndCaveBiome biome, Set<BlockPos> blocks) {
        blocks.forEach(pos -> this.setBiome(world, (BlockPos)pos, biome));
    }

    public void setBiome(ISeedReader world, BlockPos pos, BetterEndCaveBiome biome) {
        IBiomeArray array = (IBiomeArray)world.func_217349_x(pos).func_225549_i_();
        if (array != null) {
            array.setBiome(biome.getActualBiome(), pos);
        }
    }

    private BlockPos findPos(ISeedReader world, BlockPos pos, int radius, Random random) {
        int top = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, pos.func_177958_n(), pos.func_177952_p());
        BlockPos.Mutable bpos = new BlockPos.Mutable();
        bpos.func_223471_o(pos.func_177958_n());
        bpos.func_223472_q(pos.func_177952_p());
        bpos.func_185336_p(top - 1);
        BlockState state = world.func_180495_p((BlockPos)bpos);
        while (!state.func_235714_a_(ModTags.GEN_TERRAIN) && bpos.func_177956_o() > 5) {
            bpos.func_185336_p(bpos.func_177956_o() - 1);
            state = world.func_180495_p((BlockPos)bpos);
        }
        if (bpos.func_177956_o() < 10) {
            return null;
        }
        top = (int)((float)bpos.func_177956_o() - ((float)radius * 1.3f + 5.0f));
        while (state.func_235714_a_(ModTags.GEN_TERRAIN) || !state.func_204520_s().func_206888_e() && bpos.func_177956_o() > 5) {
            bpos.func_185336_p(bpos.func_177956_o() - 1);
            state = world.func_180495_p((BlockPos)bpos);
        }
        int bottom = (int)((float)bpos.func_177956_o() + (float)radius * 1.3f + 5.0f);
        if (top <= bottom) {
            return null;
        }
        return new BlockPos(pos.func_177958_n(), ModMathHelper.randRange(bottom, top, random), pos.func_177952_p());
    }

    protected void fixBlocks(ISeedReader world, Set<BlockPos> caveBlocks) {
        BlockPos pos = caveBlocks.iterator().next();
        BlockPos.Mutable start = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        BlockPos.Mutable end = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        caveBlocks.forEach(bpos -> {
            if (bpos.func_177958_n() < start.func_177958_n()) {
                start.func_223471_o(bpos.func_177958_n());
            }
            if (bpos.func_177958_n() > end.func_177958_n()) {
                end.func_223471_o(bpos.func_177958_n());
            }
            if (bpos.func_177956_o() < start.func_177956_o()) {
                start.func_185336_p(bpos.func_177956_o());
            }
            if (bpos.func_177956_o() > end.func_177956_o()) {
                end.func_185336_p(bpos.func_177956_o());
            }
            if (bpos.func_177952_p() < start.func_177952_p()) {
                start.func_223472_q(bpos.func_177952_p());
            }
            if (bpos.func_177952_p() > end.func_177952_p()) {
                end.func_223472_q(bpos.func_177952_p());
            }
        });
        BlockHelper.fixBlocks((IWorld)world, start.func_177982_a(-5, -5, -5), end.func_177982_a(5, 5, 5));
    }

    protected boolean isWaterNear(ISeedReader world, BlockPos pos) {
        for (Direction dir : BlockHelper.DIRECTIONS) {
            if (world.func_204610_c(pos.func_177967_a(dir, 5)).func_206888_e()) continue;
            return true;
        }
        return false;
    }

    protected boolean biomeMissingCaves(ISeedReader world, BlockPos pos) {
        for (int x = -2; x < 3; ++x) {
            for (int z = -2; z < 3; ++z) {
                Biome biome = world.func_226691_t_(pos.func_177982_a(x << 4, 0, z << 4));
                BetterEndBiome endBiome = ModBiomes.getFromBiome(biome);
                if (endBiome.hasCaves()) continue;
                return true;
            }
        }
        return false;
    }

    static {
        ArrayList prePos = Lists.newArrayList();
        int radius = 5;
        int r2 = radius * radius;
        for (int x = -radius; x <= radius; ++x) {
            int x2 = x * x;
            for (int y = -radius; y <= radius; ++y) {
                int y2 = y * y;
                for (int z = -radius; z <= radius; ++z) {
                    int z2 = z * z;
                    if (x2 + y2 + z2 >= r2) continue;
                    prePos.add(new Vector3i(x, y, z));
                }
            }
        }
        SPHERE = prePos.toArray(new Vector3i[0]);
    }
}

