/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.generator;

import mod.beethoven92.betterendforge.config.jsons.JsonConfig;
import net.minecraft.util.math.MathHelper;

public class LayerOptions {
    public final float distance;
    public final float scale;
    public final float coverage;
    public final int center;
    public final int heightVariation;
    public final int minY;
    public final int maxY;
    public final long centerDist;
    public final boolean hasCentralIsland;

    public LayerOptions(String name, JsonConfig config, float distance, float scale, int center, int heightVariation, boolean hasCentral) {
        this.distance = this.clampDistance(config.getFloat(name, "distance[1-8192]", distance));
        this.scale = this.clampScale(config.getFloat(name, "scale[0.1-1024]", scale));
        this.center = this.clampCenter(config.getInt(name, "averageHeight[0-255]", center));
        this.heightVariation = this.clampVariation(config.getInt(name, "heightVariation[0-255]", heightVariation));
        this.coverage = this.clampCoverage(config.getFloat(name, "coverage[0-1]", 0.5f));
        this.minY = this.center - this.heightVariation;
        this.maxY = this.center + this.heightVariation;
        this.centerDist = MathHelper.func_76141_d((float)(1000.0f / this.distance));
        this.hasCentralIsland = config.getBoolean(name, "hasCentralIsland", hasCentral);
    }

    private float clampDistance(float value) {
        return MathHelper.func_76131_a((float)value, (float)1.0f, (float)8192.0f);
    }

    private float clampScale(float value) {
        return MathHelper.func_76131_a((float)value, (float)0.1f, (float)1024.0f);
    }

    private float clampCoverage(float value) {
        return 0.9999f - MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f) * 2.0f;
    }

    private int clampCenter(int value) {
        return MathHelper.func_76125_a((int)value, (int)0, (int)255);
    }

    private int clampVariation(int value) {
        return MathHelper.func_76125_a((int)value, (int)0, (int)255);
    }
}

