/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.generator;

import java.util.Random;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import net.minecraft.util.math.BlockPos;

public class VoronoiNoise {
    private static final Random RANDOM = new Random();
    final int seed;

    public VoronoiNoise() {
        this(0);
    }

    public VoronoiNoise(int seed) {
        this.seed = seed;
    }

    private int getSeed(int x, int y, int z) {
        int h = this.seed + x * 374761393 + y * 668265263 + z;
        h = (h ^ h >> 13) * 1274126177;
        return h ^ h >> 16;
    }

    public double sample(double x, double y, double z) {
        int ix = ModMathHelper.floor(x);
        int iy = ModMathHelper.floor(y);
        int iz = ModMathHelper.floor(z);
        float px = (float)(x - (double)ix);
        float py = (float)(y - (double)iy);
        float pz = (float)(z - (double)iz);
        float d = 10.0f;
        for (int pox = -1; pox < 2; ++pox) {
            for (int poy = -1; poy < 2; ++poy) {
                for (int poz = -1; poz < 2; ++poz) {
                    RANDOM.setSeed(this.getSeed(pox + ix, poy + iy, poz + iz));
                    float pointX = (float)pox + RANDOM.nextFloat();
                    float pointY = (float)poy + RANDOM.nextFloat();
                    float pointZ = (float)poz + RANDOM.nextFloat();
                    float d2 = ModMathHelper.lengthSqr(pointX - px, pointY - py, pointZ - pz);
                    if (!(d2 < d)) continue;
                    d = d2;
                }
            }
        }
        return Math.sqrt(d);
    }

    public BlockPos[] getPos(double x, double y, double z, double scale) {
        int ix = ModMathHelper.floor(x);
        int iy = ModMathHelper.floor(y);
        int iz = ModMathHelper.floor(z);
        float px = (float)(x - (double)ix);
        float py = (float)(y - (double)iy);
        float pz = (float)(z - (double)iz);
        float d = 10.0f;
        float selX = 0.0f;
        float selY = 0.0f;
        float selZ = 0.0f;
        float selXPre = 0.0f;
        float selYPre = 0.0f;
        float selZPre = 0.0f;
        for (int pox = -1; pox < 2; ++pox) {
            for (int poy = -1; poy < 2; ++poy) {
                for (int poz = -1; poz < 2; ++poz) {
                    RANDOM.setSeed(this.getSeed(pox + ix, poy + iy, poz + iz));
                    float pointX = (float)pox + RANDOM.nextFloat();
                    float pointY = (float)poy + RANDOM.nextFloat();
                    float pointZ = (float)poz + RANDOM.nextFloat();
                    float d2 = ModMathHelper.lengthSqr(pointX - px, pointY - py, pointZ - pz);
                    if (!(d2 < d)) continue;
                    d = d2;
                    selXPre = selX;
                    selYPre = selY;
                    selZPre = selZ;
                    selX = pointX;
                    selY = pointY;
                    selZ = pointZ;
                }
            }
        }
        BlockPos p1 = new BlockPos(((double)ix + (double)selX) * scale, ((double)iy + (double)selY) * scale, ((double)iz + (double)selZ) * scale);
        BlockPos p2 = new BlockPos(((double)ix + (double)selXPre) * scale, ((double)iy + (double)selYPre) * scale, ((double)iz + (double)selZPre) * scale);
        return new BlockPos[]{p1, p2};
    }
}

