/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.surfacebuilder;

import java.util.Random;
import mod.beethoven92.betterendforge.common.init.ModSurfaceBuilders;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class UmbraSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    private static final OpenSimplexNoise NOISE = new OpenSimplexNoise(1512L);

    public UmbraSurfaceBuilder() {
        super(SurfaceBuilderConfig.field_237203_a_);
    }

    public static BlockState getSurfaceState(BlockPos pos) {
        return UmbraSurfaceBuilder.getConfig(pos.func_177958_n(), pos.func_177952_p(), ModMathHelper.RANDOM).func_204108_a();
    }

    private static SurfaceBuilderConfig getConfig(int x, int z, Random random) {
        float grass = (float)NOISE.eval((double)x * 0.03, (double)z * 0.03) + (float)NOISE.eval((double)x * 0.1, (double)z * 0.1) * 0.6f + random.nextFloat() * 0.2f - 0.05f;
        if (grass > 0.4f) {
            return ModSurfaceBuilders.Configs.PALLIDIUM_FULL_SURFACE_CONFIG;
        }
        if (grass > 0.15f) {
            return ModSurfaceBuilders.Configs.PALLIDIUM_HEAVY_SURFACE_CONFIG;
        }
        if ((double)grass > -0.15) {
            return ModSurfaceBuilders.Configs.PALLIDIUM_THIN_SURFACE_CONFIG;
        }
        if (grass > -0.4f) {
            return ModSurfaceBuilders.Configs.PALLIDIUM_TINY_SURFACE_CONFIG;
        }
        return ModSurfaceBuilders.Configs.UMBRA_SURFACE_CONFIG;
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        int depth = (int)(NOISE.eval((double)x * 0.1, (double)z * 0.1) * 20.0 + NOISE.eval((double)x * 0.5, (double)z * 0.5) * 10.0 + 60.0);
        config = UmbraSurfaceBuilder.getConfig(x, z, random);
        SurfaceBuilder.field_215396_G.func_205610_a_(random, chunkIn, biomeIn, x, z, startHeight, noise + (double)depth, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)config);
    }
}

