/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.config.jsons;

import javax.annotation.Nullable;
import mod.beethoven92.betterendforge.config.jsons.JsonConfig;
import mod.beethoven92.betterendforge.config.jsons.JsonConfigKeeper;
import mod.beethoven92.betterendforge.config.jsons.JsonConfigKey;

public class JsonPathConfig
extends JsonConfig {
    public JsonPathConfig(String modID, String group, boolean autoSync, boolean diffContent) {
        super(modID, group, autoSync, diffContent);
    }

    public JsonPathConfig(String modID, String group, boolean autoSync) {
        super(modID, group, autoSync);
    }

    public JsonPathConfig(String modID, String group) {
        super(modID, group);
    }

    @Override
    protected void registerEntries() {
    }

    protected static JsonConfigKey createKey(String category, String key) {
        return new JsonConfigKey(key, category.split("\\."));
    }

    protected static JsonConfigKey createKey(String key) {
        return JsonPathConfig.createKey("", key);
    }

    @Nullable
    public <T, E extends JsonConfigKeeper.Entry<T>> E getEntry(String category, String key, Class<E> type) {
        return this.getEntry(JsonPathConfig.createKey(category, key), type);
    }

    @Nullable
    public <T, E extends JsonConfigKeeper.Entry<T>> T getDefault(String category, String key, Class<E> type) {
        return this.getDefault(JsonPathConfig.createKey(category, key), type);
    }

    public String getString(String category, String key, String defaultValue) {
        return this.getString(JsonPathConfig.createKey(category, key), defaultValue);
    }

    public String getString(String category, String key) {
        return this.getString(JsonPathConfig.createKey(category, key));
    }

    public boolean setString(String category, String key, String value) {
        return this.setString(JsonPathConfig.createKey(category, key), value);
    }

    @Override
    public int getInt(String category, String key, int defaultValue) {
        return this.getInt(JsonPathConfig.createKey(category, key), defaultValue);
    }

    @Override
    public int getInt(String category, String key) {
        return this.getInt(JsonPathConfig.createKey(category, key));
    }

    public boolean setInt(String category, String key, int value) {
        return this.setInt(JsonPathConfig.createKey(category, key), value);
    }

    public boolean setRangedInt(String category, String key, int value) {
        return this.setRanged(JsonPathConfig.createKey(category, key), value, JsonConfigKeeper.IntegerRange.class);
    }

    public boolean setRangedFloat(String category, String key, float value) {
        return this.setRanged(JsonPathConfig.createKey(category, key), Float.valueOf(value), JsonConfigKeeper.FloatRange.class);
    }

    @Override
    public float getFloat(String category, String key, float defaultValue) {
        return this.getFloat(JsonPathConfig.createKey(category, key), defaultValue);
    }

    @Override
    public float getFloat(String category, String key) {
        return this.getFloat(JsonPathConfig.createKey(category, key));
    }

    public boolean setFloat(String category, String key, float value) {
        return this.setFloat(JsonPathConfig.createKey(category, key), value);
    }

    @Override
    public boolean getBoolean(String category, String key, boolean defaultValue) {
        return this.getBoolean(JsonPathConfig.createKey(category, key), defaultValue);
    }

    @Override
    public boolean getBoolean(String category, String key) {
        return this.getBoolean(JsonPathConfig.createKey(category, key));
    }

    public boolean setBoolean(String category, String key, boolean value) {
        return this.setBoolean(JsonPathConfig.createKey(category, key), value);
    }

    public String getStringRoot(String key, String defaultValue) {
        return this.getString(JsonPathConfig.createKey(key), defaultValue);
    }

    public String getStringRoot(String key) {
        return this.getString(JsonPathConfig.createKey(key));
    }

    public boolean setStringRoot(String key, String value) {
        return this.setString(JsonPathConfig.createKey(key), value);
    }

    public int getIntRoot(String key, int defaultValue) {
        return this.getInt(JsonPathConfig.createKey(key), defaultValue);
    }

    public int getIntRoot(String key) {
        return this.getInt(JsonPathConfig.createKey(key));
    }

    public boolean setIntRoot(String key, int value) {
        return this.setInt(JsonPathConfig.createKey(key), value);
    }

    public boolean setRangedIntRoot(String key, int value) {
        return this.setRanged(JsonPathConfig.createKey(key), value, JsonConfigKeeper.IntegerRange.class);
    }

    public boolean setRangedFloatRoot(String key, float value) {
        return this.setRanged(JsonPathConfig.createKey(key), Float.valueOf(value), JsonConfigKeeper.FloatRange.class);
    }

    public float getFloatRoot(String key, float defaultValue) {
        return this.getFloat(JsonPathConfig.createKey(key), defaultValue);
    }

    public float getFloatRoot(String key) {
        return this.getFloat(JsonPathConfig.createKey(key));
    }

    public boolean setFloatRoot(String key, float value) {
        return this.setFloat(JsonPathConfig.createKey(key), value);
    }

    public boolean getBooleanRoot(String key, boolean defaultValue) {
        return this.getBoolean(JsonPathConfig.createKey(key), defaultValue);
    }

    public boolean getBooleanRoot(String key) {
        return this.getBoolean(JsonPathConfig.createKey(key));
    }

    public boolean setBooleanRoot(String key, boolean value) {
        return this.setBoolean(JsonPathConfig.createKey(key), value);
    }
}

