/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.mixin;

import java.util.Random;
import mod.beethoven92.betterendforge.BetterEnd;
import mod.beethoven92.betterendforge.common.util.StructureHelper;
import mod.beethoven92.betterendforge.common.util.WorldDataAPI;
import mod.beethoven92.betterendforge.common.world.generator.GeneratorOptions;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.EndPodiumFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.fml.loading.FMLLoader;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EndPodiumFeature.class})
public abstract class EndPodiumFeatureMixin {
    @Shadow
    @Final
    private boolean field_186141_c;

    @Inject(method={"generate"}, at={@At(value="HEAD")}, cancellable=true)
    private void beGeneratePortal(ISeedReader level, ChunkGenerator chunkGenerator, Random random, BlockPos origin, NoFeatureConfig config, CallbackInfoReturnable<Boolean> info) {
        if (!GeneratorOptions.hasPortal()) {
            info.setReturnValue((Object)false);
            info.cancel();
        } else if (GeneratorOptions.replacePortal() && FMLLoader.getLoadingModList().getModFileById("endergetic") == null) {
            ISeedReader world = level;
            BlockPos blockPos = this.be_updatePos(origin, world);
            Template structure = StructureHelper.readStructure(BetterEnd.makeID(this.field_186141_c ? "portal/end_portal_active" : "portal/end_portal_inactive"));
            BlockPos size = structure.func_186259_a();
            blockPos = blockPos.func_177982_a(-(size.func_177958_n() >> 1), -1, -(size.func_177952_p() >> 1));
            structure.func_237146_a_((IServerWorld)world, blockPos, blockPos, new PlacementSettings(), random, 2);
            info.setReturnValue((Object)true);
            info.cancel();
        }
    }

    private BlockPos be_updatePos(BlockPos blockPos, ISeedReader world) {
        if (GeneratorOptions.useNewGenerator()) {
            BlockPos pos = GeneratorOptions.getPortalPos();
            if (pos.equals((Object)BlockPos.field_177992_a)) {
                int y = world.func_217348_a(0, 0, ChunkStatus.field_222617_m).func_201576_a(Heightmap.Type.WORLD_SURFACE, blockPos.func_177958_n(), blockPos.func_177952_p());
                if (y < 1) {
                    y = 65;
                }
                pos = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
                GeneratorOptions.setPortalPos(pos);
                WorldDataAPI.getRootTag("betterendforge").func_218657_a("portal", (INBT)NBTUtil.func_186859_a((BlockPos)pos));
            }
            return pos;
        }
        return blockPos;
    }
}

