/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.mixin;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import mod.beethoven92.betterendforge.client.ClientOptions;
import mod.beethoven92.betterendforge.common.init.ModBiomes;
import mod.beethoven92.betterendforge.common.util.BackgroundInfo;
import mod.beethoven92.betterendforge.common.world.biome.BetterEndBiome;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FogRenderer.class})
public abstract class FogRendererMixin {
    private static float lastFogDensity;
    private static float fogDensity;
    private static float lerp;
    private static long time;
    @Shadow
    private static float field_205093_c;
    @Shadow
    private static float field_205094_d;
    @Shadow
    private static float field_205095_e;

    @Inject(method={"updateFogColor"}, at={@At(value="RETURN")})
    private static void onRender(ActiveRenderInfo activeRenderInfoIn, float partialTicks, ClientWorld worldIn, int renderDistanceChunks, float bossColorModifier, CallbackInfo info) {
        FluidState fluidState;
        long l = Util.func_211177_b() - time;
        time += l;
        if ((lerp += (float)l * 0.001f) > 1.0f) {
            lerp = 1.0f;
        }
        if ((fluidState = activeRenderInfoIn.func_216771_k()).func_206888_e() && worldIn.func_234923_W_().equals(World.field_234920_i_)) {
            Entity entity = activeRenderInfoIn.func_216773_g();
            boolean skip = false;
            if (entity instanceof LivingEntity) {
                EffectInstance effect = ((LivingEntity)entity).func_70660_b(Effects.field_76439_r);
                boolean bl = skip = effect != null && effect.func_76459_b() > 0;
            }
            if (!skip) {
                field_205093_c *= 4.0f;
                field_205094_d *= 4.0f;
                field_205095_e *= 4.0f;
            }
        }
        BackgroundInfo.red = field_205093_c;
        BackgroundInfo.green = field_205094_d;
        BackgroundInfo.blue = field_205095_e;
    }

    @Inject(at={@At(value="HEAD")}, remap=false, method={"setupFog(Lnet/minecraft/client/renderer/ActiveRenderInfo;Lnet/minecraft/client/renderer/FogRenderer$FogType;FZF)V"}, cancellable=true)
    private static void fogDensity(ActiveRenderInfo activeRenderInfoIn, FogRenderer.FogType fogTypeIn, float farPlaneDistance, boolean nearFog, float partialTicks, CallbackInfo info) {
        Entity entity = activeRenderInfoIn.func_216773_g();
        Biome biome = entity.field_70170_p.func_226691_t_(entity.func_233580_cy_());
        FluidState fluidState = activeRenderInfoIn.func_216771_k();
        if (ClientOptions.useFogDensity() && biome.func_201856_r() == Biome.Category.THEEND && fluidState.func_206888_e()) {
            float fog;
            BetterEndBiome endBiome = ModBiomes.getRenderBiome(biome);
            if (fogDensity == 0.0f) {
                lastFogDensity = fogDensity = endBiome.getFogDensity();
            }
            if (lerp == 1.0f) {
                lastFogDensity = fogDensity;
                fogDensity = endBiome.getFogDensity();
                lerp = 0.0f;
            }
            BackgroundInfo.fog = fog = MathHelper.func_219799_g((float)lerp, (float)lastFogDensity, (float)fogDensity);
            float start = farPlaneDistance * 0.75f / fog;
            float end = farPlaneDistance / fog;
            if (entity instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)entity;
                EffectInstance effect = le.func_70660_b(Effects.field_76440_q);
                if (effect != null) {
                    int duration = effect.func_76459_b();
                    if (duration > 20) {
                        start = 0.0f;
                        end *= 0.03f;
                        BackgroundInfo.blindness = 1.0f;
                    } else {
                        float delta;
                        BackgroundInfo.blindness = delta = (float)duration / 20.0f;
                        start = MathHelper.func_219799_g((float)delta, (float)start, (float)0.0f);
                        end = MathHelper.func_219799_g((float)delta, (float)end, (float)(end * 0.03f));
                    }
                } else {
                    BackgroundInfo.blindness = 0.0f;
                }
            }
            RenderSystem.fogStart((float)start);
            RenderSystem.fogEnd((float)end);
            RenderSystem.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
            RenderSystem.setupNvFogDistance();
            info.cancel();
        }
    }
}

