/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged;

import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import someoneelse.betternetherreforged.NetherTags;
import someoneelse.betternetherreforged.biomes.NetherBiome;
import someoneelse.betternetherreforged.blocks.BNRenderLayer;
import someoneelse.betternetherreforged.client.IRenderTypeable;
import someoneelse.betternetherreforged.config.Config;
import someoneelse.betternetherreforged.config.Configs;
import someoneelse.betternetherreforged.datagen.DataGenerators;
import someoneelse.betternetherreforged.recipes.ItemRecipes;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.registry.BrewingRegistry;
import someoneelse.betternetherreforged.registry.CityRegistry;
import someoneelse.betternetherreforged.registry.ConfiguredStructureRegistry;
import someoneelse.betternetherreforged.registry.EntityRegistry;
import someoneelse.betternetherreforged.registry.EntityRenderRegistry;
import someoneelse.betternetherreforged.registry.FuelRegistry;
import someoneelse.betternetherreforged.registry.ItemsRegistry;
import someoneelse.betternetherreforged.registry.NetherBiomesRegistry;
import someoneelse.betternetherreforged.registry.SoundsRegistry;
import someoneelse.betternetherreforged.registry.StructurePieceRegistry;
import someoneelse.betternetherreforged.registry.StructureRegistry;
import someoneelse.betternetherreforged.registry.TileEntitiesRegistry;
import someoneelse.betternetherreforged.registry.TileEntityRenderRegistry;
import someoneelse.betternetherreforged.world.BNWorldGenerator;
import someoneelse.betternetherreforged.world.NetherBiomeProvider;
import someoneelse.betternetherreforged.world.structures.piece.StructureTypes;

@Mod(value="betternether")
public class BetterNether {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "betternether";
    private static boolean thinArmor = true;
    private static boolean lavafallParticles = true;
    private static float fogStart = 0.05f;
    private static float fogEnd = 0.5f;
    private static Method GETCODEC_METHOD;

    public BetterNether() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        this.initOptions();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(DataGenerators::gatherData);
        forgeEventBus.addListener(FuelRegistry::onFuelBurnTimeEvent);
        modEventBus.addListener(NetherBiomesRegistry::createRegistry);
        modEventBus.addGenericListener(SoundEvent.class, SoundsRegistry::registerAll);
        modEventBus.addGenericListener(EntityType.class, EntityRegistry::registerAll);
        modEventBus.addGenericListener(Block.class, BlocksRegistry::registerAll);
        modEventBus.addGenericListener(Item.class, ItemsRegistry::registerAll);
        modEventBus.addGenericListener(TileEntityType.class, TileEntitiesRegistry::registerAll);
        modEventBus.addGenericListener(NetherBiome.class, NetherBiomesRegistry::registerNetherBiomes);
        modEventBus.addGenericListener(Biome.class, NetherBiomesRegistry::registerBiomes);
        NetherBiomesRegistry.init();
        StructureTypes.init();
        EntityRegistry.registerNetherEntities();
        BNWorldGenerator.onModInit();
        BrewingRegistry.register();
        Config.save();
        StructureRegistry.STRUCTURES.register(modEventBus);
        StructureRegistry.FEATURES.register(modEventBus);
        NetherTags.init();
        CityRegistry.DEFERRED_REGISTRY_STRUCTURE.register(modEventBus);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, this::addDimensionalSpacing);
        forgeBus.addListener(EventPriority.HIGH, this::biomeModification);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        this.registerRenderLayers();
        EntityRenderRegistry.register();
        TileEntityRenderRegistry.register();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        StructurePieceRegistry.init();
        ItemRecipes.register();
        event.enqueueWork(() -> {
            CityRegistry.setupStructures();
            ConfiguredStructureRegistry.registerConfiguredStructures();
            NetherBiomeProvider.register();
        });
    }

    private void initOptions() {
        thinArmor = Configs.MAIN.getBoolean("improvement", "smaller_armor_offset", true);
        lavafallParticles = Configs.MAIN.getBoolean("improvement", "lavafall_particles", true);
        float density = Configs.MAIN.getFloat("improvement", "fog_density[vanilla: 1.0]", 0.75f);
        BetterNether.changeFogDensity(density);
    }

    private void registerRenderLayers() {
        RenderType cutout = RenderType.func_228643_e_();
        RenderType translucent = RenderType.func_228645_f_();
        ForgeRegistries.BLOCKS.forEach(block -> {
            if (block instanceof IRenderTypeable) {
                BNRenderLayer layer = ((IRenderTypeable)block).getRenderLayer();
                if (layer == BNRenderLayer.CUTOUT) {
                    RenderTypeLookup.setRenderLayer((Block)block, (RenderType)cutout);
                } else if (layer == BNRenderLayer.TRANSLUCENT) {
                    RenderTypeLookup.setRenderLayer((Block)block, (RenderType)translucent);
                }
            }
        });
    }

    public static boolean hasThinArmor() {
        return thinArmor;
    }

    public static void setThinArmor(boolean value) {
        thinArmor = value;
    }

    public static boolean hasLavafallParticles() {
        return lavafallParticles;
    }

    public static void changeFogDensity(float density) {
        fogStart = -0.45f * density + 0.5f;
        fogEnd = -0.5f * density + 1.0f;
    }

    public static float getFogStart() {
        return fogStart;
    }

    public static float getFogEnd() {
        return fogEnd;
    }

    public void biomeModification(BiomeLoadingEvent event) {
        Biome.Category category = event.getCategory();
        switch (category) {
            case NETHER: {
                event.getGeneration().getStructures().add(() -> ConfiguredStructureRegistry.CONFIGURED_CITY);
            }
        }
    }

    public static <T extends IForgeRegistryEntry<T>> T register(IForgeRegistry<T> registry, T entry, String registryKey) {
        entry.setRegistryName(new ResourceLocation(MOD_ID, registryKey));
        registry.register(entry);
        return entry;
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            try {
                ResourceLocation cgRL;
                if (GETCODEC_METHOD == null) {
                    GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
                }
                if ((cgRL = Registry.field_239690_aB_.func_177774_c((Object)((Codec)GETCODEC_METHOD.invoke((Object)serverWorld.func_72863_F().field_186029_c, new Object[0])))) != null && cgRL.func_110624_b().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error("Was unable to check if " + serverWorld.func_234923_W_().func_240901_a_() + " is using Terraforged's ChunkGenerator.");
            }
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234919_h_)) {
                return;
            }
            HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.putIfAbsent(CityRegistry.CITY.get(), DimensionStructuresSettings.field_236191_b_.get((Object)CityRegistry.CITY.get()));
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_().get(tempMap);
        }
    }
}

