/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.biomes;

import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.ParticleEffectAmbience;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.MHelper;
import someoneelse.betternetherreforged.biomes.BiomeDefinition;
import someoneelse.betternetherreforged.biomes.NetherBiome;
import someoneelse.betternetherreforged.noise.OpenSimplexNoise;
import someoneelse.betternetherreforged.registry.EntityRegistry;
import someoneelse.betternetherreforged.structures.StructureType;
import someoneelse.betternetherreforged.structures.plants.StructureCrimsonFungus;
import someoneelse.betternetherreforged.structures.plants.StructureCrimsonPinewood;
import someoneelse.betternetherreforged.structures.plants.StructureCrimsonRoots;
import someoneelse.betternetherreforged.structures.plants.StructureGoldenVine;
import someoneelse.betternetherreforged.structures.plants.StructureWallMoss;
import someoneelse.betternetherreforged.structures.plants.StructureWallRedMushroom;
import someoneelse.betternetherreforged.structures.plants.StructureWartBush;
import someoneelse.betternetherreforged.structures.plants.StructureWartSeed;

public class CrimsonPinewood
extends NetherBiome {
    private static final OpenSimplexNoise TERRAIN = new OpenSimplexNoise(614L);

    public CrimsonPinewood(String name) {
        super(new BiomeDefinition(name).setFogColor(51, 3, 3).setLoop(SoundEvents.field_232711_f_).setAdditions(SoundEvents.field_232701_e_).setMood(SoundEvents.field_232722_g_).setParticleConfig(new ParticleEffectAmbience((IParticleData)ParticleTypes.field_239814_an_, 0.025f)).addMobSpawn(EntityRegistry.FLYING_PIG, 20, 2, 4));
        this.addStructure("crimson_pinewood", new StructureCrimsonPinewood(), StructureType.FLOOR, 0.2f, false);
        this.addStructure("wart_bush", new StructureWartBush(), StructureType.FLOOR, 0.1f, false);
        this.addStructure("wart_seed", new StructureWartSeed(), StructureType.FLOOR, 0.05f, true);
        this.addStructure("crimson_fungus", new StructureCrimsonFungus(), StructureType.FLOOR, 0.05f, true);
        this.addStructure("crimson_roots", new StructureCrimsonRoots(), StructureType.FLOOR, 0.2f, true);
        this.addStructure("golden_vine", new StructureGoldenVine(), StructureType.CEIL, 0.3f, true);
        this.addStructure("wall_moss", new StructureWallMoss(), StructureType.WALL, 0.8f, true);
        this.addStructure("wall_red_mushroom", new StructureWallRedMushroom(), StructureType.WALL, 0.4f, true);
    }

    @Override
    public void genSurfColumn(IWorld world, BlockPos pos, Random random) {
        if (TERRAIN.eval((double)pos.func_177958_n() * 0.1, (double)pos.func_177952_p() * 0.1) > (double)MHelper.randRange(0.5f, 0.7f, random)) {
            BlocksHelper.setWithoutUpdate(world, pos, Blocks.field_189878_dg.func_176223_P());
        } else {
            BlocksHelper.setWithoutUpdate(world, pos, Blocks.field_235381_mu_.func_176223_P());
        }
    }
}

