/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.biomes;

import java.util.Random;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.ParticleEffectAmbience;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.biomes.BiomeDefinition;
import someoneelse.betternetherreforged.biomes.NetherBiome;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.registry.SoundsRegistry;
import someoneelse.betternetherreforged.structures.StructureType;
import someoneelse.betternetherreforged.structures.plants.StructureGiantMold;
import someoneelse.betternetherreforged.structures.plants.StructureGrayMold;
import someoneelse.betternetherreforged.structures.plants.StructureLucis;
import someoneelse.betternetherreforged.structures.plants.StructureMedBrownMushroom;
import someoneelse.betternetherreforged.structures.plants.StructureMedRedMushroom;
import someoneelse.betternetherreforged.structures.plants.StructureMushroomFir;
import someoneelse.betternetherreforged.structures.plants.StructureOrangeMushroom;
import someoneelse.betternetherreforged.structures.plants.StructureRedMold;
import someoneelse.betternetherreforged.structures.plants.StructureVanillaMushroom;
import someoneelse.betternetherreforged.structures.plants.StructureWallBrownMushroom;
import someoneelse.betternetherreforged.structures.plants.StructureWallRedMushroom;

public class NetherMushroomForest
extends NetherBiome {
    public NetherMushroomForest(String name) {
        super(new BiomeDefinition(name).setFogColor(166, 38, 95).setLoop(SoundsRegistry.AMBIENT_MUSHROOM_FOREST).setAdditions(SoundEvents.field_232701_e_).setMood(SoundEvents.field_232722_g_).setMusic(SoundEvents.field_232762_ir_).setParticleConfig(new ParticleEffectAmbience((IParticleData)ParticleTypes.field_197596_G, 0.1f)));
        this.setNoiseDensity(0.5f);
        this.addStructure("large_red_mushroom", new StructureMedRedMushroom(), StructureType.FLOOR, 0.12f, true);
        this.addStructure("large_brown_mushroom", new StructureMedBrownMushroom(), StructureType.FLOOR, 0.12f, true);
        this.addStructure("giant_mold", new StructureGiantMold(), StructureType.FLOOR, 0.12f, true);
        this.addStructure("mushroom_fir", new StructureMushroomFir(), StructureType.FLOOR, 0.2f, true);
        this.addStructure("vanilla_mushrooms", new StructureVanillaMushroom(), StructureType.FLOOR, 0.1f, false);
        this.addStructure("orange_mushroom", new StructureOrangeMushroom(), StructureType.FLOOR, 0.05f, true);
        this.addStructure("red_mold", new StructureRedMold(), StructureType.FLOOR, 0.5f, true);
        this.addStructure("gray_mold", new StructureGrayMold(), StructureType.FLOOR, 0.5f, true);
        this.addStructure("lucis", new StructureLucis(), StructureType.WALL, 0.05f, false);
        this.addStructure("wall_red_mushroom", new StructureWallRedMushroom(), StructureType.WALL, 0.8f, true);
        this.addStructure("wall_brown_mushroom", new StructureWallBrownMushroom(), StructureType.WALL, 0.8f, true);
    }

    @Override
    public void genSurfColumn(IWorld world, BlockPos pos, Random random) {
        BlocksHelper.setWithoutUpdate(world, pos, BlocksRegistry.NETHER_MYCELIUM.func_176223_P());
    }
}

