/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.biomes;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.ParticleEffectAmbience;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.MHelper;
import someoneelse.betternetherreforged.biomes.BiomeDefinition;
import someoneelse.betternetherreforged.biomes.NetherBiome;
import someoneelse.betternetherreforged.blocks.BlockSoulSandstone;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.registry.EntityRegistry;
import someoneelse.betternetherreforged.structures.StructureType;
import someoneelse.betternetherreforged.structures.plants.StructureBlackBush;
import someoneelse.betternetherreforged.structures.plants.StructureNetherWart;
import someoneelse.betternetherreforged.structures.plants.StructureSoulLily;
import someoneelse.betternetherreforged.structures.plants.StructureWartDeadwood;
import someoneelse.betternetherreforged.structures.plants.StructureWartSeed;
import someoneelse.betternetherreforged.structures.plants.StructureWartTree;

public class NetherWartForest
extends NetherBiome {
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();

    public NetherWartForest(String name) {
        super(new BiomeDefinition(name).setFogColor(151, 6, 6).setLoop(SoundEvents.field_232711_f_).setAdditions(SoundEvents.field_232701_e_).setMood(SoundEvents.field_232722_g_).setMusic(SoundEvents.field_232762_ir_).setParticleConfig(new ParticleEffectAmbience((IParticleData)ParticleTypes.field_239814_an_, 0.05f)).addMobSpawn(EntityRegistry.FLYING_PIG, 20, 2, 4));
        this.setNoiseDensity(0.45f);
        this.addStructure("wart_deadwood", new StructureWartDeadwood(), StructureType.FLOOR, 0.02f, false);
        this.addStructure("wart_tree", new StructureWartTree(), StructureType.FLOOR, 0.1f, false);
        this.addStructure("nether_wart", new StructureNetherWart(), StructureType.FLOOR, 0.2f, false);
        this.addStructure("wart_seed", new StructureWartSeed(), StructureType.FLOOR, 0.05f, false);
        this.addStructure("black_bush", new StructureBlackBush(), StructureType.FLOOR, 0.05f, false);
        this.addStructure("soul_lily", new StructureSoulLily(), StructureType.FLOOR, 0.2f, true);
    }

    @Override
    public void genSurfColumn(IWorld world, BlockPos pos, Random random) {
        switch (random.nextInt(4)) {
            case 0: {
                super.genSurfColumn(world, pos, random);
                break;
            }
            case 1: {
                BlocksHelper.setWithoutUpdate(world, pos, Blocks.field_150425_aM.func_176223_P());
                break;
            }
            case 2: {
                BlocksHelper.setWithoutUpdate(world, pos, Blocks.field_235336_cN_.func_176223_P());
                break;
            }
            case 3: {
                BlocksHelper.setWithoutUpdate(world, pos, BlocksRegistry.NETHERRACK_MOSS.func_176223_P());
            }
        }
        int d1 = MHelper.randRange(2, 4, random);
        POS.func_223471_o(pos.func_177958_n());
        POS.func_223472_q(pos.func_177952_p());
        for (int i = 1; i < d1; ++i) {
            POS.func_185336_p(pos.func_177956_o() - i);
            if (BlocksHelper.isNetherGround(world.func_180495_p((BlockPos)POS))) {
                switch (random.nextInt(3)) {
                    case 0: {
                        BlocksHelper.setWithoutUpdate(world, pos, Blocks.field_150425_aM.func_176223_P());
                        break;
                    }
                    case 1: {
                        BlocksHelper.setWithoutUpdate(world, pos, Blocks.field_235336_cN_.func_176223_P());
                        break;
                    }
                    case 2: {
                        BlocksHelper.setWithoutUpdate(world, pos, Blocks.field_150424_aL.func_176223_P());
                    }
                }
                continue;
            }
            return;
        }
        int d2 = MHelper.randRange(5, 7, random);
        for (int i = d1; i < d2; ++i) {
            POS.func_185336_p(pos.func_177956_o() - i);
            if (!BlocksHelper.isNetherGround(world.func_180495_p((BlockPos)POS))) {
                return;
            }
            BlocksHelper.setWithoutUpdate(world, (BlockPos)POS, (BlockState)BlocksRegistry.SOUL_SANDSTONE.func_176223_P().func_206870_a((Property)BlockSoulSandstone.UP, (Comparable)Boolean.valueOf(i == d1)));
        }
    }
}

