/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.biomes;

import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.biomes.BiomeDefinition;
import someoneelse.betternetherreforged.biomes.NetherBiome;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.registry.EntityRegistry;
import someoneelse.betternetherreforged.structures.StructureType;
import someoneelse.betternetherreforged.structures.plants.StructureBlackBush;
import someoneelse.betternetherreforged.structures.plants.StructureNetherWart;
import someoneelse.betternetherreforged.structures.plants.StructureWartSeed;

public class NetherWartForestEdge
extends NetherBiome {
    public NetherWartForestEdge(String name) {
        super(new BiomeDefinition(name).setFogColor(191, 28, 28).setLoop(SoundEvents.field_232711_f_).setAdditions(SoundEvents.field_232701_e_).setMood(SoundEvents.field_232722_g_).setMusic(SoundEvents.field_232762_ir_).addMobSpawn(EntityRegistry.FLYING_PIG, 20, 2, 4));
        this.addStructure("nether_wart", new StructureNetherWart(), StructureType.FLOOR, 0.02f, false);
        this.addStructure("wart_seed", new StructureWartSeed(), StructureType.FLOOR, 0.01f, false);
        this.addStructure("black_bush", new StructureBlackBush(), StructureType.FLOOR, 0.01f, false);
    }

    @Override
    public void genSurfColumn(IWorld world, BlockPos pos, Random random) {
        switch (random.nextInt(3)) {
            case 0: {
                super.genSurfColumn(world, pos, random);
                break;
            }
            case 1: {
                BlocksHelper.setWithoutUpdate(world, pos, Blocks.field_150425_aM.func_176223_P());
                break;
            }
            case 2: {
                BlocksHelper.setWithoutUpdate(world, pos, Blocks.field_235336_cN_.func_176223_P());
                break;
            }
            case 3: {
                BlocksHelper.setWithoutUpdate(world, pos, BlocksRegistry.NETHERRACK_MOSS.func_176223_P());
            }
        }
        for (int i = 1; i < random.nextInt(3); ++i) {
            BlockPos down = pos.func_177979_c(i);
            if (random.nextInt(3) != 0 || !BlocksHelper.isNetherGround(world.func_180495_p(down))) continue;
            BlocksHelper.setWithoutUpdate(world, down, Blocks.field_150425_aM.func_176223_P());
        }
    }
}

