/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.biomes;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.biomes.BiomeDefinition;
import someoneelse.betternetherreforged.biomes.NetherBiome;
import someoneelse.betternetherreforged.noise.OpenSimplexNoise;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.registry.SoundsRegistry;
import someoneelse.betternetherreforged.structures.StructureType;
import someoneelse.betternetherreforged.structures.plants.StructureBlackBush;
import someoneelse.betternetherreforged.structures.plants.StructureBlackVine;
import someoneelse.betternetherreforged.structures.plants.StructureFeatherFern;
import someoneelse.betternetherreforged.structures.plants.StructureJellyfishMushroom;
import someoneelse.betternetherreforged.structures.plants.StructureOldWillow;
import someoneelse.betternetherreforged.structures.plants.StructureReeds;
import someoneelse.betternetherreforged.structures.plants.StructureSmoker;
import someoneelse.betternetherreforged.structures.plants.StructureSoulVein;
import someoneelse.betternetherreforged.structures.plants.StructureSwampGrass;
import someoneelse.betternetherreforged.structures.plants.StructureWallBrownMushroom;
import someoneelse.betternetherreforged.structures.plants.StructureWallMoss;
import someoneelse.betternetherreforged.structures.plants.StructureWallRedMushroom;
import someoneelse.betternetherreforged.structures.plants.StructureWillow;
import someoneelse.betternetherreforged.structures.plants.StructureWillowBush;

public class OldSwampland
extends NetherBiome {
    protected static final OpenSimplexNoise TERRAIN = new OpenSimplexNoise(523L);

    public OldSwampland(String name) {
        super(new BiomeDefinition(name).setFogColor(137, 19, 78).setLoop(SoundsRegistry.AMBIENT_SWAMPLAND).setAdditions(SoundEvents.field_232701_e_).setMood(SoundEvents.field_232722_g_).setMusic(SoundEvents.field_232762_ir_).setDefaultMobs(false).addMobSpawn(EntityType.field_233589_aE_, 40, 2, 4).addMobSpawn(EntityType.field_200771_K, 40, 2, 4));
        this.addStructure("old_willow", new StructureOldWillow(), StructureType.FLOOR, 0.02f, false);
        this.addStructure("willow", new StructureWillow(), StructureType.FLOOR, 0.02f, false);
        this.addStructure("willow_bush", new StructureWillowBush(), StructureType.FLOOR, 0.1f, true);
        this.addStructure("feather_fern", new StructureFeatherFern(), StructureType.FLOOR, 0.05f, true);
        this.addStructure("nether_reed", new StructureReeds(), StructureType.FLOOR, 0.8f, false);
        this.addStructure("soul_vein", new StructureSoulVein(), StructureType.FLOOR, 0.5f, false);
        this.addStructure("smoker", new StructureSmoker(), StructureType.FLOOR, 0.05f, false);
        this.addStructure("jellyfish_mushroom", new StructureJellyfishMushroom(), StructureType.FLOOR, 0.03f, true);
        this.addStructure("black_bush", new StructureBlackBush(), StructureType.FLOOR, 0.01f, false);
        this.addStructure("swamp_grass", new StructureSwampGrass(), StructureType.FLOOR, 0.4f, false);
        this.addStructure("black_vine", new StructureBlackVine(), StructureType.CEIL, 0.4f, true);
        this.addStructure("wall_moss", new StructureWallMoss(), StructureType.WALL, 0.8f, true);
        this.addStructure("wall_red_mushroom", new StructureWallRedMushroom(), StructureType.WALL, 0.8f, true);
        this.addStructure("wall_brown_mushroom", new StructureWallBrownMushroom(), StructureType.WALL, 0.8f, true);
    }

    @Override
    public void genSurfColumn(IWorld world, BlockPos pos, Random random) {
        double value = TERRAIN.eval((double)pos.func_177958_n() * 0.2, (double)pos.func_177956_o() * 0.2, (double)pos.func_177952_p() * 0.2);
        if (value > 0.3 && this.validWalls(world, pos)) {
            BlocksHelper.setWithoutUpdate(world, pos, Blocks.field_150353_l.func_176223_P());
        } else if (value > -0.3) {
            BlocksHelper.setWithoutUpdate(world, pos, BlocksRegistry.SWAMPLAND_GRASS.func_176223_P());
        } else {
            value = TERRAIN.eval((double)pos.func_177958_n() * 0.5, (double)pos.func_177952_p() * 0.5);
            BlocksHelper.setWithoutUpdate(world, pos, value > 0.0 ? Blocks.field_150425_aM.func_176223_P() : Blocks.field_235336_cN_.func_176223_P());
        }
    }

    protected boolean validWalls(IWorld world, BlockPos pos) {
        return this.validWall(world, pos.func_177977_b()) && this.validWall(world, pos.func_177978_c()) && this.validWall(world, pos.func_177968_d()) && this.validWall(world, pos.func_177974_f()) && this.validWall(world, pos.func_177976_e());
    }

    protected boolean validWall(IWorld world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return BlocksHelper.isLava(state) || BlocksHelper.isNetherGround(state);
    }
}

