/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.blocks;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.blocks.BNRenderLayer;
import someoneelse.betternetherreforged.blocks.BlockBaseNotFull;

public class BlockBoneMushroom
extends BlockBaseNotFull {
    private static final VoxelShape SHAPE_NORTH = BlockBoneMushroom.func_208617_a((double)1.0, (double)1.0, (double)8.0, (double)15.0, (double)15.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = BlockBoneMushroom.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)8.0);
    private static final VoxelShape SHAPE_WEST = BlockBoneMushroom.func_208617_a((double)8.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    private static final VoxelShape SHAPE_EAST = BlockBoneMushroom.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)8.0, (double)15.0, (double)15.0);
    private static final VoxelShape SHAPE_UP = BlockBoneMushroom.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0);
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final IntegerProperty AGE = IntegerProperty.func_177719_a((String)"age", (int)0, (int)2);

    public BlockBoneMushroom() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)MaterialColor.field_151672_u).func_200947_a(SoundType.field_222472_s).func_226896_b_().func_200942_a().func_200946_b().func_200944_c());
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.setDropItself(false);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)FACING, (Comparable)Direction.UP));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateManager) {
        stateManager.func_206894_a(new Property[]{FACING, AGE});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader view, BlockPos pos, ISelectionContext ePos) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_UP;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader view, BlockPos pos) {
        return 1.0f;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        if (direction == Direction.DOWN) {
            return false;
        }
        BlockPos blockPos = pos.func_177972_a(direction.func_176734_d());
        BlockState blockState = world.func_180495_p(blockPos);
        return BlocksHelper.isBone(blockState);
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (Property<Direction>)FACING);
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal(state, mirror, (Property<Direction>)FACING);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (this.func_196260_a(state, (IWorldReader)world, pos)) {
            return state;
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        super.func_225534_a_(state, world, pos, random);
        int age = (Integer)state.func_177229_b((Property)AGE);
        if (age < 2 && random.nextInt(32) == 0) {
            BlocksHelper.setWithoutUpdate((IWorld)world, pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
        }
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState blockState = this.func_176223_P();
        World IWorldReader2 = ctx.func_195991_k();
        BlockPos blockPos = ctx.func_195995_a();
        Direction[] directions = ctx.func_196009_e();
        for (int i = 0; i < directions.length; ++i) {
            Direction direction2;
            Direction direction = directions[i];
            if (direction == Direction.UP || !(blockState = (BlockState)blockState.func_206870_a((Property)FACING, (Comparable)(direction2 = direction.func_176734_d()))).func_196955_c((IWorldReader)IWorldReader2, blockPos)) continue;
            return blockState;
        }
        return null;
    }
}

