/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.blocks;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.blocks.BNRenderLayer;
import someoneelse.betternetherreforged.blocks.BlockBaseNotFull;

public class BlockCommonPlant
extends BlockBaseNotFull
implements IGrowable {
    public static final IntegerProperty AGE = IntegerProperty.func_177719_a((String)"age", (int)0, (int)3);

    public BlockCommonPlant(MaterialColor color) {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)MaterialColor.field_151646_E).func_200947_a(SoundType.field_222472_s).func_226896_b_().func_200942_a().func_200946_b().func_200944_c());
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.setDropItself(false);
    }

    public BlockCommonPlant(AbstractBlock.Properties settings) {
        super(settings);
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.setDropItself(false);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateManager) {
        stateManager.func_206894_a(new Property[]{AGE});
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return BlocksHelper.isNetherGround(world.func_180495_p(pos.func_177977_b()));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (!this.func_196260_a(state, (IWorldReader)world, pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return state;
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((Property)AGE) < 3;
    }

    public boolean func_180670_a(World world, Random random, BlockPos pos, BlockState state) {
        int age = (Integer)state.func_177229_b((Property)AGE);
        if (age < 3) {
            return BlocksHelper.isFertile(world.func_180495_p(pos.func_177977_b())) ? random.nextBoolean() : random.nextInt(4) == 0;
        }
        return false;
    }

    protected boolean canGrowTerrain(World world, Random random, BlockPos pos, BlockState state) {
        int age = (Integer)state.func_177229_b((Property)AGE);
        if (age < 3) {
            return BlocksHelper.isFertile(world.func_180495_p(pos.func_177977_b())) ? random.nextInt(8) == 0 : random.nextInt(16) == 0;
        }
        return false;
    }

    public void func_225535_a_(ServerWorld world, Random random, BlockPos pos, BlockState state) {
        int age = (Integer)state.func_177229_b((Property)AGE);
        world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        super.func_225534_a_(state, world, pos, random);
        if (this.canGrowTerrain((World)world, random, pos, state)) {
            this.func_225535_a_(world, random, pos, state);
        }
    }
}

