/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.blocks;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.blocks.BNRenderLayer;
import someoneelse.betternetherreforged.blocks.BlockBaseNotFull;

public class BlockCommonSapling
extends BlockBaseNotFull
implements IGrowable {
    private static final VoxelShape SHAPE = BlockCommonSapling.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);
    private Block plant;

    public BlockCommonSapling(Block plant, MaterialColor color) {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)color).func_200947_a(SoundType.field_222472_s).func_226896_b_().func_222380_e().func_200946_b().func_200942_a().func_200944_c());
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.plant = plant;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader view, BlockPos pos, ISelectionContext ePos) {
        return SHAPE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return BlocksHelper.isNetherGround(world.func_180495_p(pos.func_177977_b()));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (!this.func_196260_a(state, (IWorldReader)world, pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return state;
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World world, Random random, BlockPos pos, BlockState state) {
        return BlocksHelper.isFertile(world.func_180495_p(pos.func_177977_b())) ? random.nextBoolean() : random.nextInt(4) == 0;
    }

    protected boolean canGrowTerrain(World world, Random random, BlockPos pos, BlockState state) {
        return BlocksHelper.isFertile(world.func_180495_p(pos.func_177977_b())) ? random.nextInt(8) == 0 : random.nextInt(16) == 0;
    }

    public void func_225535_a_(ServerWorld world, Random random, BlockPos pos, BlockState state) {
        world.func_175656_a(pos, this.plant.func_176223_P());
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        super.func_225534_a_(state, world, pos, random);
        if (this.canGrowTerrain((World)world, random, pos, state)) {
            this.func_225535_a_(world, random, pos, state);
        }
    }
}

