/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.blocks.BlockBaseNotFull;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.structures.plants.StructureLucis;

public class BlockLucisSpore
extends BlockBaseNotFull
implements IGrowable {
    private static final EnumMap<Direction, VoxelShape> BOUNDING_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)BlockLucisSpore.func_208617_a((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0), (Object)Direction.SOUTH, (Object)BlockLucisSpore.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0), (Object)Direction.WEST, (Object)BlockLucisSpore.func_208617_a((double)8.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), (Object)Direction.EAST, (Object)BlockLucisSpore.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0)));
    private static final StructureLucis STRUCTURE = new StructureLucis();
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;

    public BlockLucisSpore() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)MaterialColor.field_151672_u).func_200947_a(SoundType.field_222472_s).func_200946_b().func_226896_b_().func_200942_a().func_200944_c().func_235838_a_(state -> 7));
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateManager) {
        stateManager.func_206894_a(new Property[]{FACING});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader view, BlockPos pos, ISelectionContext ePos) {
        return BOUNDING_SHAPES.get(state.func_177229_b((Property)FACING));
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World world, Random random, BlockPos pos, BlockState state) {
        return random.nextInt(16) == 0;
    }

    public void func_225535_a_(ServerWorld world, Random random, BlockPos pos, BlockState state) {
        STRUCTURE.generate((IServerWorld)world, pos, random);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (this.func_196260_a(state, (IWorldReader)world, pos)) {
            return state;
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        super.func_225534_a_(state, world, pos, random);
        if (this.func_180670_a((World)world, random, pos, state)) {
            this.func_225535_a_(world, random, pos, state);
        }
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (Property<Direction>)FACING);
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal(state, mirror, (Property<Direction>)FACING);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        BlockPos blockPos = pos.func_177972_a(direction.func_176734_d());
        BlockState blockState = world.func_180495_p(blockPos);
        return BlocksHelper.isNetherrack(blockState) || BlocksRegistry.ANCHOR_TREE.isTreeLog(blockState.func_177230_c());
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState blockState = this.func_176223_P();
        World worldView = ctx.func_195991_k();
        BlockPos blockPos = ctx.func_195995_a();
        Direction[] directions = ctx.func_196009_e();
        for (int i = 0; i < directions.length; ++i) {
            Direction direction2;
            Direction direction = directions[i];
            if (!direction.func_176740_k().func_176722_c() || !(blockState = (BlockState)blockState.func_206870_a((Property)FACING, (Comparable)(direction2 = direction.func_176734_d()))).func_196955_c((IWorldReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }
}

