/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.blocks.BNRenderLayer;
import someoneelse.betternetherreforged.blocks.BlockBaseNotFull;
import someoneelse.betternetherreforged.blocks.shapes.TripleShape;

public class BlockNeonEquisetum
extends BlockBaseNotFull
implements IGrowable {
    protected static final VoxelShape SHAPE_SELECTION = BlockNeonEquisetum.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final EnumProperty<TripleShape> SHAPE = EnumProperty.func_177709_a((String)"shape", TripleShape.class);

    public BlockNeonEquisetum() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)MaterialColor.field_151651_C).func_200947_a(SoundType.field_222472_s).func_200942_a().func_222380_e().func_200946_b().func_226896_b_().func_235838_a_(state -> 15));
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(SHAPE, (Comparable)((Object)TripleShape.BOTTOM)));
        this.setDropItself(false);
    }

    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.XZ;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateManager) {
        stateManager.func_206894_a(new Property[]{SHAPE});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader view, BlockPos pos, ISelectionContext ePos) {
        Vector3d vec3d = state.func_191059_e(view, pos);
        return SHAPE_SELECTION.func_197751_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader view, BlockPos pos) {
        return 1.0f;
    }

    public boolean func_200123_i(BlockState state, IBlockReader view, BlockPos pos) {
        return true;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockState up = world.func_180495_p(pos.func_177984_a());
        return up.func_177230_c() == this || BlocksHelper.isNetherrack(up);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (!this.func_196260_a(state, (IWorldReader)world, pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return state;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockPos upPos = pos.func_177984_a();
        if (world.func_180495_p(upPos).func_177230_c() == this) {
            world.func_175656_a(upPos, (BlockState)this.func_176223_P().func_206870_a(SHAPE, (Comparable)((Object)TripleShape.MIDDLE)));
            upPos = upPos.func_177984_a();
            if (world.func_180495_p(upPos).func_177230_c() == this) {
                world.func_175656_a(upPos, (BlockState)this.func_176223_P().func_206870_a(SHAPE, (Comparable)((Object)TripleShape.TOP)));
            }
        }
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ItemStack tool = (ItemStack)builder.func_216019_b(LootParameters.field_216289_i);
        if (tool != null && tool.func_77973_b().func_206844_a((ITag)Tags.Items.SHEARS) || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)tool) > 0) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)this.func_199767_j())});
        }
        return Lists.newArrayList();
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        BlockPos.Mutable blockPos = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        for (int y = pos.func_177956_o() - 1; y > 1; --y) {
            blockPos.func_185336_p(y);
            if (world.func_180495_p((BlockPos)blockPos).func_177230_c() == this) continue;
            return world.func_180495_p((BlockPos)blockPos).func_177230_c() == Blocks.field_150350_a;
        }
        return false;
    }

    public boolean func_180670_a(World world, Random random, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld world, Random random, BlockPos pos, BlockState state) {
        BlockPos.Mutable blockPos = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        for (int y = pos.func_177956_o(); y > 1; --y) {
            blockPos.func_185336_p(y);
            if (world.func_180495_p((BlockPos)blockPos).func_177230_c() != this) break;
        }
        BlocksHelper.setWithoutUpdate((IWorld)world, (BlockPos)blockPos, this.func_176223_P());
        this.func_180633_a((World)world, (BlockPos)blockPos, state, null, null);
    }
}

